/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.model.papi.PapiManager;
import com.tacz.guns.client.resource.pojo.display.gun.Align;
import com.tacz.guns.client.resource.pojo.display.gun.TextShow;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class TextShowRender
implements IFunctionalRenderer {
    private final BedrockGunModel bedrockGunModel;
    private final TextShow textShow;
    private final ItemStack gunStack;

    public TextShowRender(BedrockGunModel bedrockGunModel, TextShow textShow, ItemStack gunStack) {
        this.bedrockGunModel = bedrockGunModel;
        this.textShow = textShow;
        this.gunStack = gunStack;
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexBuffer, ItemDisplayContext transformType, int light, int overlay) {
        if (!transformType.m_269069_()) {
            return;
        }
        String text = PapiManager.getTextShow(this.textShow.getTextKey(), this.gunStack);
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        Matrix3f normal = new Matrix3f((Matrix3fc)poseStack.m_85850_().m_252943_());
        Matrix4f pose = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.bedrockGunModel.delegateRender((poseStack1, vertexBuffer1, transformType1, light1, overlay1) -> {
            Font font = Minecraft.m_91087_().f_91062_;
            boolean shadow = this.textShow.isShadow();
            int color = this.textShow.getColorInt();
            float scale = this.textShow.getScale();
            int packLight = LightTexture.m_109885_((int)this.textShow.getTextLight(), (int)this.textShow.getTextLight());
            int width = font.m_92895_(text);
            int xOffset = switch (this.textShow.getAlign()) {
                case Align.CENTER -> width / 2;
                case Align.RIGHT -> width;
                default -> 0;
            };
            PoseStack poseStack2 = new PoseStack();
            poseStack2.m_85850_().m_252943_().mul((Matrix3fc)normal);
            poseStack2.m_85850_().m_252922_().mul((Matrix4fc)pose);
            poseStack2.m_85841_(0.006666667f * scale, -0.006666667f * scale, -0.006666667f);
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            float f = -xOffset;
            Objects.requireNonNull(font);
            font.m_271703_(text, f, (float)(-9) / 2.0f, color, shadow, poseStack2.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packLight);
            bufferSource.m_109911_();
        });
    }
}

