/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.util.InputExtraCheck;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ShootKey {
    public static final KeyMapping SHOOT_KEY = new KeyMapping("key.tacz.shoot.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.MOUSE, 0, "key.category.tacz");

    @SubscribeEvent
    public static void autoShoot(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END && !InputExtraCheck.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            FireMode fireMode = iGun.getFireMode(mainHandItem);
            boolean isBurstAuto = fireMode == FireMode.BURST && TimelessAPI.getCommonGunIndex(iGun.getGunId(mainHandItem)).map(index -> index.getGunData().getBurstData().isContinuousShoot()).orElse(false) != false;
            IClientPlayerGunOperator operator = IClientPlayerGunOperator.fromLocalPlayer(player);
            if (SHOOT_KEY.m_90857_() && (fireMode == FireMode.AUTO || isBurstAuto)) {
                operator.shoot();
            }
        }
    }

    public static boolean autoShootController() {
        if (!InputExtraCheck.isInGame()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_5833_()) {
            return false;
        }
        ItemStack mainHandItem = player.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            FireMode fireMode = iGun.getFireMode(mainHandItem);
            boolean isBurstAuto = fireMode == FireMode.BURST && TimelessAPI.getCommonGunIndex(iGun.getGunId(mainHandItem)).map(index -> index.getGunData().getBurstData().isContinuousShoot()).orElse(false) != false;
            IClientPlayerGunOperator operator = IClientPlayerGunOperator.fromLocalPlayer(player);
            if (fireMode == FireMode.AUTO || isBurstAuto) {
                return operator.shoot() == ShootResult.SUCCESS;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void semiShoot(InputEvent.MouseButton.Post event) {
        if (InputExtraCheck.isInGame() && SHOOT_KEY.m_90830_(event.getButton())) {
            if (event.getAction() == 0) {
                SoundPlayManager.resetDryFireSound();
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player == null || player.m_5833_()) {
                return;
            }
            ItemStack mainHandItem = player.m_21205_();
            Item item = mainHandItem.m_41720_();
            if (item instanceof IGun) {
                boolean isBurstSemi;
                IGun iGun = (IGun)item;
                FireMode fireMode = iGun.getFireMode(mainHandItem);
                boolean bl = isBurstSemi = fireMode == FireMode.BURST && TimelessAPI.getCommonGunIndex(iGun.getGunId(mainHandItem)).map(index -> !index.getGunData().getBurstData().isContinuousShoot()).orElse(false) != false;
                if (fireMode == FireMode.UNKNOWN) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.tacz.fire_select.fail"));
                }
                if (fireMode == FireMode.SEMI || isBurstSemi) {
                    IClientPlayerGunOperator.fromLocalPlayer(player).shoot();
                }
            }
        }
    }

    public static boolean semiShootController(boolean isPress) {
        if (!InputExtraCheck.isInGame()) {
            return false;
        }
        if (!isPress) {
            SoundPlayManager.resetDryFireSound();
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_5833_()) {
            return false;
        }
        ItemStack mainHandItem = player.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (item instanceof IGun) {
            boolean isBurstSemi;
            IGun iGun = (IGun)item;
            FireMode fireMode = iGun.getFireMode(mainHandItem);
            boolean bl = isBurstSemi = fireMode == FireMode.BURST && TimelessAPI.getCommonGunIndex(iGun.getGunId(mainHandItem)).map(index -> !index.getGunData().getBurstData().isContinuousShoot()).orElse(false) != false;
            if (fireMode == FireMode.UNKNOWN) {
                player.m_213846_((Component)Component.m_237115_((String)"message.tacz.fire_select.fail"));
                return false;
            }
            if (fireMode == FireMode.SEMI || isBurstSemi) {
                return IClientPlayerGunOperator.fromLocalPlayer(player).shoot() == ShootResult.SUCCESS;
            }
        }
        return false;
    }
}

