/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateMachine;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.event.common.GunDrawEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerDrawGun;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LocalPlayerDraw {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerDraw(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void draw(ItemStack lastItem) {
        this.resetData();
        ItemStack currentItem = this.player.m_21205_();
        long drawTime = System.currentTimeMillis() - this.data.clientDrawTimestamp;
        IGun currentGun = IGun.getIGunOrNull(currentItem);
        IGun lastGun = IGun.getIGunOrNull(lastItem);
        if (drawTime >= 0L) {
            drawTime = this.getDrawTime(lastItem, lastGun, drawTime);
        }
        long putAwayTime = Math.abs(drawTime);
        if (Minecraft.m_91087_().f_91072_ != null) {
            Minecraft.m_91087_().f_91072_.m_105297_();
        }
        NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerDrawGun());
        MinecraftForge.EVENT_BUS.post((Event)new GunDrawEvent((LivingEntity)this.player, lastItem, currentItem, LogicalSide.CLIENT));
        if (drawTime >= 0L) {
            this.doPutAway(lastItem, lastGun, putAwayTime);
        }
        if (currentGun != null) {
            this.doDraw(currentItem, putAwayTime);
            AttachmentPropertyManager.postChangeEvent((LivingEntity)this.player, currentItem);
        }
    }

    private void doDraw(ItemStack currentItem, long putAwayTime) {
        TimelessAPI.getGunDisplay(currentItem).ifPresent(display -> {
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine == null) {
                return;
            }
            if (animationStateMachine.isInitialized()) {
                ((AnimationStateMachine)animationStateMachine).exit();
            }
            GunAnimationStateContext context = new GunAnimationStateContext();
            context.setCurrentGunItem(currentItem);
            animationStateMachine.setContext(context);
            ((AnimationStateMachine)animationStateMachine).initialize();
            if (this.data.drawFuture != null) {
                this.data.drawFuture.cancel(false);
            }
            this.data.drawFuture = LocalPlayerDataHolder.SCHEDULED_EXECUTOR_SERVICE.schedule(() -> Minecraft.m_91087_().m_18689_(() -> {
                animationStateMachine.trigger("draw");
                SoundPlayManager.stopPlayGunSound();
                SoundPlayManager.playDrawSound((LivingEntity)this.player, display);
            }), putAwayTime, TimeUnit.MILLISECONDS);
        });
    }

    private void doPutAway(ItemStack lastItem, IGun lastGun, long putAwayTime) {
        if (lastGun == null) {
            return;
        }
        TimelessAPI.getGunDisplay(lastItem).ifPresent(display -> {
            Minecraft.m_91087_().m_18689_(() -> {
                SoundPlayManager.stopPlayGunSound();
                SoundPlayManager.playPutAwaySound((LivingEntity)this.player, display);
            });
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.processContextIfExist(context -> {
                    context.setPutAwayTime((float)putAwayTime / 1000.0f);
                    context.setCurrentGunItem(lastItem);
                });
                animationStateMachine.trigger("put_away");
                KeepingItemRenderer.getRenderer().keep(lastItem, putAwayTime);
                if (animationStateMachine.isInitialized()) {
                    ((AnimationStateMachine)animationStateMachine).exit();
                }
            }
        });
    }

    private long getDrawTime(ItemStack lastItem, IGun lastGun, long drawTime) {
        if (lastGun != null) {
            Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(lastGun.getGunId(lastItem));
            float putAwayTime = gunIndex.map(index -> Float.valueOf(index.getGunData().getPutAwayTime())).orElse(Float.valueOf(0.0f)).floatValue();
            if ((float)drawTime > putAwayTime * 1000.0f) {
                drawTime = (long)(putAwayTime * 1000.0f);
            }
            this.data.clientDrawTimestamp = System.currentTimeMillis() + drawTime;
        } else {
            drawTime = 0L;
            this.data.clientDrawTimestamp = System.currentTimeMillis();
        }
        return drawTime;
    }

    private void resetData() {
        this.data.lockState(operator -> operator.getSynDrawCoolDown() > 0L);
        this.data.isShootRecorded = true;
        this.data.clientShootTimestamp = -1L;
        this.data.clientIsAiming = false;
        this.data.clientAimingProgress = 0.0f;
        LocalPlayerDataHolder.oldAimingProgress = 0.0f;
        this.data.isBolting = false;
        if (this.data.clientDrawTimestamp == -1L) {
            this.data.clientDrawTimestamp = System.currentTimeMillis();
        }
    }
}

