/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.other;

import com.google.common.collect.Maps;
import com.tacz.guns.api.client.other.IThirdPersonAnimation;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public final class ThirdPersonManager {
    private static final Map<String, IThirdPersonAnimation> CACHE = Maps.newHashMap();
    private static final String RESERVED_DEFAULT_NAME = "default";
    private static final IThirdPersonAnimation DEFAULT = new IThirdPersonAnimation(){

        @Override
        public void animateGunHold(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head) {
            rightArm.f_104204_ = -0.3f + head.f_104204_;
            leftArm.f_104204_ = 0.8f + head.f_104204_;
            rightArm.f_104203_ = -1.4f + head.f_104203_;
            leftArm.f_104203_ = -1.4f + head.f_104203_;
        }

        @Override
        public void animateGunAim(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head, float aimProgress) {
            float lerp1 = Mth.m_14179_((float)aimProgress, (float)0.3f, (float)0.35f);
            float lerp2 = Mth.m_14179_((float)aimProgress, (float)1.4f, (float)1.6f);
            rightArm.f_104204_ = -lerp1 + head.f_104204_;
            leftArm.f_104204_ = 0.8f + head.f_104204_;
            rightArm.f_104203_ = -lerp2 + head.f_104203_;
            leftArm.f_104203_ = -lerp2 + head.f_104203_;
        }
    };

    public static void registerDefault() {
        CACHE.put(RESERVED_DEFAULT_NAME, DEFAULT);
    }

    public static void register(String name, IThirdPersonAnimation animation) {
        if (name.equals(RESERVED_DEFAULT_NAME)) {
            return;
        }
        CACHE.put(name, animation);
    }

    public static IThirdPersonAnimation getAnimation(String name) {
        return CACHE.getOrDefault(name, DEFAULT);
    }
}

