/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.mixin;

import com.gumillea.cosmopolitan.core.util.CosmoItemTags;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShapedRecipe.class})
public abstract class ShapedRecipeMixin {
    @Inject(method={"assemble(Lnet/minecraft/world/inventory/CraftingContainer;Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onAssemble(CraftingContainer inv, RegistryAccess access, CallbackInfoReturnable<ItemStack> cir) {
        TagKey<Item> CONDENSED_MILK = CosmoItemTags.CONDENSED_MILK;
        TagKey<Item> CREAM = CosmoItemTags.CREAM;
        ItemStack result = (ItemStack)cir.getReturnValue();
        boolean hasMilk = false;
        boolean hasCream = false;
        if (!(result.m_41720_().m_41472_() || result.m_204117_(CONDENSED_MILK) || result.m_204117_(CREAM))) {
            return;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack slot = inv.m_8020_(i);
            CompoundTag tag = slot.m_41783_();
            if (slot.m_204117_(CONDENSED_MILK)) {
                hasMilk = true;
            }
            if (slot.m_204117_(CREAM)) {
                hasCream = true;
            }
            if (tag != null) {
                if (tag.m_128471_("has_condensed_milk")) {
                    hasMilk = true;
                }
                if (tag.m_128471_("has_cream")) {
                    hasCream = true;
                }
            }
            if (hasMilk && hasCream) break;
        }
        if (hasMilk || hasCream) {
            CompoundTag tag = result.m_41784_();
            if (hasMilk) {
                tag.m_128379_("has_condensed_milk", true);
            }
            if (hasCream) {
                tag.m_128379_("has_cream", true);
            }
            cir.setReturnValue((Object)result);
        }
    }
}

