/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.mixin;

import com.gumillea.cosmopolitan.core.util.CosmoItemTags;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;

@Mixin(value={CookingPotRecipe.class}, remap=false)
public class CookingPotRecipeMixin {
    @Unique
    private boolean hasMilk;
    @Unique
    private boolean hasCream;

    @Inject(method={"matches(Lnet/minecraftforge/items/wrapper/RecipeWrapper;Lnet/minecraft/world/level/Level;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void onMatches(RecipeWrapper inv, Level level, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            this.hasMilk = false;
            this.hasCream = false;
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                CompoundTag tag = stack.m_41783_();
                if (!stack.m_41619_()) {
                    if (stack.m_204117_(CosmoItemTags.CONDENSED_MILK)) {
                        this.hasMilk = true;
                    }
                    if (stack.m_204117_(CosmoItemTags.CREAM)) {
                        this.hasCream = true;
                    }
                    if (tag != null) {
                        if (tag.m_128471_("has_condensed_milk")) {
                            this.hasMilk = true;
                        }
                        if (tag.m_128471_("has_cream")) {
                            this.hasCream = true;
                        }
                    }
                }
                if (this.hasMilk && this.hasCream) break;
            }
        }
    }

    @Inject(method={"getResultItem(Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true, remap=true)
    private void onGetResultItem(RegistryAccess access, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack result = ((ItemStack)cir.getReturnValue()).m_41777_();
        if (!result.m_41619_() && result.m_41720_().m_41472_()) {
            CompoundTag tag = result.m_41784_();
            if (this.hasMilk) {
                tag.m_128379_("has_condensed_milk", true);
            }
            if (this.hasCream) {
                tag.m_128379_("has_cream", true);
            }
        }
        cir.setReturnValue((Object)result);
    }

    @Inject(method={"getOutputContainer()Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetOutputContainer(CallbackInfoReturnable<ItemStack> cir) {
        ItemStack container = ((ItemStack)cir.getReturnValue()).m_41777_();
        if (!container.m_41619_()) {
            cir.setReturnValue((Object)container);
        }
    }
}

