/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.core.util;

import com.gumillea.cosmopolitan.CosmoConfig;
import com.gumillea.cosmopolitan.core.reg.CosmoEffects;
import com.gumillea.cosmopolitan.core.util.CosmoItemTags;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cosmopolitan", value={Dist.CLIENT})
public class CosmoTooltipEvent {
    @SubscribeEvent
    public static void onEffectItemTooltip(ItemTooltipEvent event) {
        int duration;
        int nutrition;
        if (!((Boolean)CosmoConfig.Client.EFFECT_TOOLTIP.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.m_41614_() && stack.getFoodProperties((LivingEntity)Minecraft.m_91087_().f_91074_) != null) {
            return;
        }
        List tooltip = event.getToolTip();
        FoodProperties properties = stack.getFoodProperties((LivingEntity)Minecraft.m_91087_().f_91074_);
        int n = nutrition = properties == null ? 0 : properties.m_38744_();
        if (((Boolean)CosmoConfig.Common.APPLE_FLAVOR.get()).booleanValue() && stack.m_204117_(CosmoItemTags.EXUBERANT_SOURCES)) {
            duration = (nutrition < 10 ? 10 - nutrition : 1) * 300;
            CosmoTooltipEvent.appendItem(tooltip, (MobEffect)CosmoEffects.EXUBERANT.get(), duration, 0);
        }
        if (((Boolean)CosmoConfig.Common.GLOW_BERRY_FLAVOR.get()).booleanValue() && stack.m_204117_(CosmoItemTags.TRACER_SOURCES)) {
            duration = nutrition < 10 ? 300 : 600;
            int amplifier = nutrition < 10 ? 0 : 1;
            CosmoTooltipEvent.appendItem(tooltip, (MobEffect)CosmoEffects.TRACER.get(), duration, amplifier);
        }
        if (((Boolean)CosmoConfig.Common.DROOPFRUIT_FLAVOR.get()).booleanValue() && stack.m_204117_(CosmoItemTags.ABYSMAL_TORCH_SOURCES)) {
            int amplifier = nutrition < 10 ? 0 : 1;
            CosmoTooltipEvent.appendItem(tooltip, (MobEffect)CosmoEffects.ABYSMAL_TORCH.get(), -1, amplifier);
        }
        if (((Boolean)CosmoConfig.Common.BLISTERBERRY_FLAVOR.get()).booleanValue() && stack.m_204117_(CosmoItemTags.VARDOGER_SOURCES)) {
            duration = (int)((double)(nutrition < 10 ? 300 : 600) * 1.5);
            CosmoTooltipEvent.appendItem(tooltip, (MobEffect)CosmoEffects.VARDOGER.get(), duration, 0);
        }
    }

    @SubscribeEvent
    public static void onSeasonedItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        List tooltip = event.getToolTip();
        if (tag.m_128471_("has_condensed_milk")) {
            tooltip.add(Component.m_237113_((String)"\u2756 ").m_7220_((Component)Component.m_237115_((String)"tooltip.cosmopolitan.seasoned.condensed_milk")).m_130938_(style -> style.m_178520_(16775392)));
        }
        if (tag.m_128471_("has_cream")) {
            tooltip.add(Component.m_237113_((String)"\u2756 ").m_7220_((Component)Component.m_237115_((String)"tooltip.cosmopolitan.seasoned.cream")).m_130938_(style -> style.m_178520_(16242612)));
        }
    }

    private static void appendItem(List<Component> tooltip, MobEffect effect, int duration, int amplifier) {
        MobEffectInstance mobEffectInstance = new MobEffectInstance(effect, duration, amplifier);
        MutableComponent component = Component.m_237115_((String)effect.m_19481_()).m_7220_((Component)(amplifier > 0 ? Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)("potion.potency." + amplifier))) : Component.m_237119_())).m_7220_((Component)(duration > 20 ? Component.m_237113_((String)" (").m_7220_(MobEffectUtil.m_267641_((MobEffectInstance)mobEffectInstance, (float)1.0f)).m_130946_(")") : Component.m_237119_())).m_130940_(effect.m_19483_().m_19497_());
        tooltip.add((Component)component);
    }
}

