/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.core.misc.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gumillea.cosmopolitan.common.blockEntity.FrozenDessertTubBlockEntity;
import com.gumillea.cosmopolitan.core.reg.CosmoRecipes;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class TubInjectRecipe
implements Recipe<Container> {
    private final ResourceLocation location;
    private final Ingredient ingredient;
    private final ItemStack resultItem;
    private final FluidStack fluid;

    public TubInjectRecipe(ResourceLocation location, Ingredient ingredient, ItemStack result, FluidStack fluid) {
        this.location = location;
        this.ingredient = ingredient;
        this.resultItem = result;
        this.fluid = fluid;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.resultItem;
    }

    public boolean m_5818_(Container inv, Level world) {
        return false;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int w, int h) {
        return false;
    }

    public ResourceLocation m_6423_() {
        return this.location;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CosmoRecipes.TUB_INJECT_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CosmoRecipes.TUB_INJECT_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.ingredient);
        return list;
    }

    @Nullable
    public static ItemStack tryApply(Level level, FrozenDessertTubBlockEntity tub, ItemStack inHand, Player player, InteractionHand hand) {
        List recipes = level.m_7465_().m_44013_((RecipeType)CosmoRecipes.TUB_INJECT_TYPE.get());
        for (TubInjectRecipe recipe : recipes) {
            FluidStack currentFluid;
            if (!recipe.getIngredient().test(inHand)) continue;
            FluidStack newFluid = recipe.getFluid().copy();
            if (inHand.m_41782_() && inHand.m_41783_().m_128471_("has_cream")) {
                CompoundTag tag = newFluid.getOrCreateTag();
                tag.m_128379_("has_cream", true);
            }
            if ((currentFluid = tub.getTank().getFluid()).isEmpty() || TubInjectRecipe.isSameNBT(currentFluid, newFluid)) {
                if (tub.getFluidHandler().fill(newFluid, IFluidHandler.FluidAction.SIMULATE) < newFluid.getAmount()) continue;
                tub.getFluidHandler().fill(newFluid, IFluidHandler.FluidAction.EXECUTE);
                ItemStack result = recipe.m_8043_(level.m_9598_()).m_41777_();
                if (!player.m_7500_()) {
                    inHand.m_41774_(1);
                    if (inHand.m_41619_()) {
                        player.m_21008_(hand, result);
                        return result;
                    }
                    if (!player.m_36356_(result)) {
                        player.m_36176_(result, false);
                    }
                    return inHand;
                }
                return inHand.m_41619_() ? ItemStack.f_41583_ : inHand;
            }
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    private static boolean isSameNBT(FluidStack currentFluid, FluidStack newFluid) {
        if (!newFluid.getFluid().m_6212_(newFluid.getFluid())) {
            return false;
        }
        CompoundTag tag = currentFluid.getTag();
        CompoundTag tag1 = newFluid.getTag();
        if (tag == null && tag1 == null) {
            return true;
        }
        if (tag == null || tag1 == null) {
            return false;
        }
        return tag.equals((Object)tag1);
    }

    public static class Serializer
    implements RecipeSerializer<TubInjectRecipe> {
        public TubInjectRecipe fromJson(ResourceLocation location, JsonObject json) {
            JsonElement element = json.get("ingredient");
            Ingredient ingredient = Ingredient.f_43901_;
            if (element.isJsonArray()) {
                ingredient = Ingredient.m_43917_((JsonElement)element.getAsJsonArray());
            } else if (element.isJsonObject()) {
                ingredient = Ingredient.m_43917_((JsonElement)element.getAsJsonObject());
            }
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"result");
            ItemStack result = ItemStack.f_41583_;
            FluidStack fluidStack = FluidStack.EMPTY;
            for (JsonElement resultElement : array) {
                JsonObject resultObj = resultElement.getAsJsonObject();
                if (resultObj.has("item")) {
                    ResourceLocation itemId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)resultObj, (String)"item"));
                    int itemCount = GsonHelper.m_13824_((JsonObject)resultObj, (String)"count", (int)1);
                    result = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(itemId)), itemCount);
                    continue;
                }
                if (!resultObj.has("fluid")) continue;
                ResourceLocation fluidId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)resultObj, (String)"fluid"));
                int fluidAmount = GsonHelper.m_13824_((JsonObject)resultObj, (String)"amount", (int)1000);
                fluidStack = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(fluidId)), fluidAmount);
            }
            return new TubInjectRecipe(location, ingredient, result, fluidStack);
        }

        @Nullable
        public TubInjectRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf byteBuf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)byteBuf);
            ItemStack itemResult = byteBuf.m_130267_();
            FluidStack fluidResult = FluidStack.readFromPacket((FriendlyByteBuf)byteBuf);
            return new TubInjectRecipe(location, ingredient, itemResult, fluidResult);
        }

        public void toNetwork(FriendlyByteBuf byteBuf, TubInjectRecipe recipe) {
            recipe.ingredient.m_43923_(byteBuf);
            byteBuf.m_130055_(recipe.resultItem);
            recipe.fluid.writeToPacket(byteBuf);
        }
    }
}

