/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.common.item;

import com.gumillea.cosmopolitan.CosmoConfig;
import com.gumillea.cosmopolitan.common.item.EffectItem;
import com.gumillea.cosmopolitan.core.reg.CosmoItems;
import com.gumillea.cosmopolitan.core.util.CosmoEvents;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class DrinkItem
extends EffectItem {
    private final boolean honey_drink;
    public final boolean tooltip;

    public DrinkItem(Item.Properties properties, boolean honey_drink, boolean tooltip) {
        super(properties);
        this.honey_drink = honey_drink;
        this.tooltip = tooltip;
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity living) {
        Player player;
        super.m_5922_(itemStack, level, living);
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, itemStack);
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if (living instanceof Player) {
            player = (Player)living;
            if (this == CosmoItems.ENCHANTED_FRUIT_MILKSHAKE.get()) {
                player.m_6756_(8);
                player.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
            }
        }
        if (!level.f_46443_) {
            if (this == CosmoItems.BIRCH_SAP_BOTTLE.get()) {
                living.m_21195_(MobEffects.f_19599_);
            }
            if (this == CosmoItems.BERRY_SYRUP_BOTTLE.get()) {
                living.m_21195_(MobEffects.f_19613_);
            }
            if (this == CosmoItems.ROOT_BEER.get()) {
                this.covertEffect(living, MobEffects.f_19599_, MobEffects.f_19598_);
            }
            if (this == CosmoItems.WILDBERRY_PUNCH.get()) {
                this.covertEffect(living, MobEffects.f_19613_, MobEffects.f_19600_);
            }
        }
        if (this == CosmoItems.BLACK_COW.get() || this == CosmoItems.ICE_CREAM_FLOAT.get()) {
            living.m_146917_(living.m_146888_() + 80);
        }
        if (this == CosmoItems.CONDENSED_MILK_BOTTLE.get()) {
            CosmoEvents.condensedMilkEffect(level, living, itemStack);
        }
        if (this == CosmoItems.CONDENSED_MILK_BUCKET.get()) {
            CosmoEvents.condensedMilkEffect(level, living, itemStack);
        }
        if (this == CosmoItems.CREAM_BUCKET.get()) {
            CosmoEvents.creamEffect(level, living, itemStack);
        }
        if (itemStack.m_41619_()) {
            return new ItemStack((ItemLike)this.m_41469_());
        }
        if (living instanceof Player) {
            player = (Player)living;
            if (!player.m_150110_().f_35937_) {
                ItemStack stack = new ItemStack((ItemLike)this.m_41469_());
                if (!player.m_150109_().m_36054_(stack)) {
                    player.m_36176_(stack, false);
                }
            }
        }
        return itemStack;
    }

    private void covertEffect(LivingEntity living, MobEffect effect, MobEffect newEffect) {
        if (living.m_21023_(effect)) {
            int a = Objects.requireNonNull(living.m_21124_(effect)).m_19564_();
            int d = Objects.requireNonNull(living.m_21124_(effect)).m_19557_();
            living.m_7292_(new MobEffectInstance(newEffect, d, a));
            living.m_21195_(effect);
        }
    }

    public int m_8105_(ItemStack itemStack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.DRINK;
    }

    public SoundEvent m_6023_() {
        return this.honey_drink ? SoundEvents.f_11970_ : SoundEvents.f_11911_;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11970_;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)CosmoConfig.Client.EFFECT_TOOLTIP.get()).booleanValue()) {
            return;
        }
        if (this.tooltip) {
            ResourceLocation key = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this));
            MutableComponent coldDrink = Component.m_237115_((String)("tooltip.cosmopolitan." + key.m_135815_() + ".when_consumed"));
            tooltip.add((Component)coldDrink.m_130940_(ChatFormatting.BLUE));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

