/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.common.client;

import com.gumillea.cosmopolitan.common.block.FrozenDessertTubBlock;
import com.gumillea.cosmopolitan.common.blockEntity.FrozenDessertTubBlockEntity;
import com.gumillea.cosmopolitan.common.fluid.CosmoIceCreamFluidType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class FrozenDessertTubRenderer
implements BlockEntityRenderer<FrozenDessertTubBlockEntity> {
    private static final float INNER_MIN = 0.125f;
    private static final float INNER_MAX = 0.875f;
    private static final float BASE_HEIGHT = 0.0625f;

    public FrozenDessertTubRenderer(BlockEntityRendererProvider.Context context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(FrozenDessertTubBlockEntity tub, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        FluidStack stack = tub.getTank().getFluid();
        FluidState state = tub.getTank().getFluid().getFluid().m_76145_();
        if (stack.isEmpty()) {
            return;
        }
        try {
            CosmoIceCreamFluidType.setTubContext(true);
            float fill = (float)stack.getAmount() / 3000.0f;
            float height = 0.0625f + 0.8125f * fill;
            Direction facing = (Direction)tub.m_58900_().m_61143_((Property)FrozenDessertTubBlock.FACING);
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            switch (facing) {
                case NORTH: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                    break;
                }
                case SOUTH: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    break;
                }
                case WEST: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    break;
                }
                case EAST: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                }
            }
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            TextureAtlasSprite sprite = this.getFluidSprite(stack);
            this.renderFluidPlane(poseStack, buffer, tub, stack, state, sprite, height, packedLight);
            poseStack.m_85849_();
        }
        finally {
            CosmoIceCreamFluidType.setTubContext(false);
        }
    }

    private TextureAtlasSprite getFluidSprite(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        FluidType type = fluid.getFluidType();
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((FluidType)type);
        ResourceLocation texture = extensions.getStillTexture(stack);
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
    }

    private void renderFluidPlane(PoseStack poseStack, MultiBufferSource buffer, FrozenDessertTubBlockEntity tub, FluidStack stack, FluidState state, TextureAtlasSprite sprite, float height, int light) {
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110466_());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        int tint = IClientFluidTypeExtensions.of((FluidType)stack.getFluid().getFluidType()).getTintColor(state, (BlockAndTintGetter)tub.m_58904_(), tub.m_58899_());
        int r = tint >> 16 & 0xFF;
        int g = tint >> 8 & 0xFF;
        int b = tint & 0xFF;
        int a = 255;
        float uMin = sprite.m_118367_(2.0);
        float uMax = sprite.m_118367_(14.0);
        float vMin = sprite.m_118393_(2.0);
        float vMax = sprite.m_118393_(14.0);
        vertexBuilder.m_252986_(matrix, 0.125f, height, 0.125f).m_6122_(r, g, b, a).m_7421_(uMin, vMin).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, 0.125f, height, 0.875f).m_6122_(r, g, b, a).m_7421_(uMin, vMax).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, 0.875f, height, 0.875f).m_6122_(r, g, b, a).m_7421_(uMax, vMax).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(matrix, 0.875f, height, 0.125f).m_6122_(r, g, b, a).m_7421_(uMax, vMin).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

