/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.mixin.client;

import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.undying.alex_cave_addon.client.animation.PlayerKeyframeAnimations;
import net.undying.alex_cave_addon.entity.ability.PlayerAccess;
import net.undying.alex_cave_addon.entity.ability.Skill;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class}, priority=1502)
public abstract class PlayerModelMixin
extends HumanoidModel<LivingEntity> {
    @Shadow
    @Final
    private ModelPart f_103374_;
    @Shadow
    @Final
    private ModelPart f_103375_;
    @Shadow
    @Final
    private ModelPart f_103376_;
    @Shadow
    @Final
    private ModelPart f_103377_;
    @Shadow
    @Final
    private ModelPart f_103378_;

    PlayerModelMixin(ModelPart root) {
        super(root);
    }

    @Inject(at={@At(value="HEAD")}, method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"})
    private void animate1(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_5607_().forEach(ModelPart::m_233569_);
            this.m_5608_().forEach(ModelPart::m_233569_);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"})
    private void animate2(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (entity instanceof Player) {
            AnimationDefinition anim;
            Player player = (Player)entity;
            float partialTick = ageInTicks - (float)player.f_19797_;
            PlayerAccess.setPartialTick(player, partialTick);
            Skill skill = Skill.fromId(PlayerAccess.getClientSkillId(player));
            if (skill != null && (anim = skill.data.getAnimation(player)) != null) {
                float ticks = (float)skill.duration - ((float)(PlayerAccess.getClientSkillTicks(player) + 1) - partialTick);
                PlayerKeyframeAnimations.animate(this.getModel(this), anim, (long)(ticks * 50.0f), 1.0f, player.m_5737_() == HumanoidArm.LEFT);
                this.f_102809_.m_104315_(this.f_102808_);
                this.f_103378_.m_104315_(this.f_102810_);
                this.f_103375_.m_104315_(this.f_102811_);
                this.f_103374_.m_104315_(this.f_102812_);
                this.f_103377_.m_104315_(this.f_102813_);
                this.f_103376_.m_104315_(this.f_102814_);
            }
        }
    }

    @Unique
    private PlayerModel<?> getModel(HumanoidModel<?> model) {
        return (PlayerModel)model;
    }
}

