/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.mixin;

import com.github.alexmodguy.alexscaves.server.block.blockentity.VolcanicCoreBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.LuxtructosaurusEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SauropodBaseEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.undying.alex_cave_addon.Config;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VolcanicCoreBlockEntity.class})
public abstract class VolcanicCoreBlockEntityMixin
extends BlockEntity {
    @Shadow(remap=false)
    private int bossSpawnCooldown;

    VolcanicCoreBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState block) {
        super(type, pos, block);
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnBoss()Z"}, remap=false, cancellable=true)
    private void spawnBossCustom(CallbackInfoReturnable<Boolean> info) {
        info.cancel();
        if (this.bossSpawnCooldown > 0) {
            info.setReturnValue((Object)false);
        } else {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BlockPos volcanoTop = this.m_58899_();
            for (int i = -5; i <= -5; ++i) {
                for (int j = -5; j <= -5; ++j) {
                    BlockPos.MutableBlockPos localTop = this.getTopOfVolcano((BlockPos)mutableBlockPos.m_122178_(this.m_58899_().m_123341_() + i, this.m_58899_().m_123342_(), this.m_58899_().m_123343_() + j));
                    if (localTop.m_123342_() <= volcanoTop.m_123342_()) continue;
                    volcanoTop = volcanoTop.m_175288_(localTop.m_123342_());
                }
            }
            LuxtructosaurusEntity luxtructosaurus = (LuxtructosaurusEntity)((EntityType)ACEntityRegistry.LUXTRUCTOSAURUS.get()).m_20615_(this.f_58857_);
            luxtructosaurus.m_146884_(Vec3.m_82514_((Vec3i)volcanoTop, (double)2.0));
            luxtructosaurus.m_6842_(true);
            luxtructosaurus.setAnimation(SauropodBaseEntity.ANIMATION_SUMMON);
            luxtructosaurus.enragedFor = 100;
            luxtructosaurus.setEnraged(true);
            this.spawnBossCustom2(this.f_58857_, (Entity)luxtructosaurus);
            this.bossSpawnCooldown = 24000;
            info.setReturnValue((Object)true);
        }
    }

    @Shadow(remap=false)
    protected abstract BlockPos.MutableBlockPos getTopOfVolcano(BlockPos var1);

    private void spawnBossCustom2(Level level, Entity entity) {
        Entity entity1;
        level.m_7967_(entity);
        if (((Boolean)Config.COMMON.DINOSAUR_JOCKEY.get()).booleanValue() && (double)level.f_46441_.m_188501_() < 0.2 && (entity1 = this.getRandomMob(level).m_20615_(level)) instanceof Mob) {
            Mob mob = (Mob)entity1;
            if (level instanceof ServerLevel) {
                ServerLevel level1 = (ServerLevel)level;
                mob.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), 0.0f);
                mob.m_6518_((ServerLevelAccessor)level1, level1.m_6436_(entity.m_20183_()), MobSpawnType.JOCKEY, null, null);
                entity.m_7998_((Entity)mob, true);
                mob.m_20049_("alex_cave_addon.lux_mount");
                mob.m_21530_();
                level.m_7967_((Entity)mob);
            }
        }
    }

    @Unique
    private EntityType<?> getRandomMob(Level level) {
        int i = level.f_46441_.m_188503_(5);
        switch (i) {
            case 0: {
                return EntityType.f_20550_;
            }
            case 1: {
                return EntityType.f_20549_;
            }
            case 2: {
                return EntityType.f_20453_;
            }
            case 3: {
                return EntityType.f_20509_;
            }
        }
        return EntityType.f_20491_;
    }
}

