/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.undying.alex_cave_addon.entity.ability.PlayerAccess;
import net.undying.alex_cave_addon.entity.ability.Skill;
import net.undying.alex_cave_addon.entity.projectile.MagneticOrbEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerAccess {
    private static final EntityDataAccessor<CompoundTag> PLAYER_DATA = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    @Unique
    @Nullable
    private MagneticOrbEntity redOrb;
    @Unique
    @Nullable
    private MagneticOrbEntity blueOrb;
    @Unique
    @Nullable
    private MagneticOrbEntity purpleOrb;
    @Unique
    private int prevSkillTicks;
    @Unique
    private int clientSkillTicks;
    @Unique
    private int clientSkillId;
    @Unique
    private float partialTick;

    PlayerMixin(EntityType<LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void addData(CallbackInfo info) {
        this.f_19804_.m_135372_(PLAYER_DATA, (Object)new CompoundTag());
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tickBefore(CallbackInfo info) {
        Player player = this.getPlayer(this);
        int i = PlayerAccess.getSkillTicks(player);
        if (i > this.prevSkillTicks) {
            this.clientSkillTicks = i;
        }
        this.prevSkillTicks = i;
        this.clientSkillId = this.clientSkillTicks <= 0 ? -1 : PlayerAccess.getSkillId(player);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tickAfter(CallbackInfo info) {
        if (!this.m_9236_().f_46443_) {
            Player player = this.getPlayer(this);
            Skill skill = PlayerAccess.getSkill(player);
            if (skill != null) {
                int ticks = PlayerAccess.getSkillTicks(player);
                skill.data.tick(player, skill.duration - ticks);
                if (ticks-- <= 0) {
                    PlayerAccess.setSkill(player, null, true);
                }
                PlayerAccess.setSkillTicks(player, ticks);
            }
            this.f_19804_.m_276349_(PLAYER_DATA, (Object)this.alexcaveaddon_getPlayerData(), true);
        } else {
            this.clientSkillTicks = Math.max(--this.clientSkillTicks, 0);
            if (this.clientSkillTicks > 0) {
                PlayerAccess.rotateBody(this.getPlayer(this));
            }
        }
    }

    @Unique
    private Player getPlayer(LivingEntity entity) {
        return (Player)entity;
    }

    @Override
    public CompoundTag alexcaveaddon_getPlayerData() {
        return (CompoundTag)this.f_19804_.m_135370_(PLAYER_DATA);
    }

    @Override
    @Nullable
    public MagneticOrbEntity alexcaveaddon_getRedOrb() {
        return this.redOrb;
    }

    @Override
    @Nullable
    public MagneticOrbEntity alexcaveaddon_getBlueOrb() {
        return this.blueOrb;
    }

    @Override
    @Nullable
    public MagneticOrbEntity alexcaveaddon_getPurpleOrb() {
        return this.purpleOrb;
    }

    @Override
    public void alexcaveaddon_setRedOrb(@Nullable MagneticOrbEntity orb) {
        this.redOrb = orb;
    }

    @Override
    public void alexcaveaddon_setBlueOrb(@Nullable MagneticOrbEntity orb) {
        this.blueOrb = orb;
    }

    @Override
    public void alexcaveaddon_setPurpleOrb(@Nullable MagneticOrbEntity orb) {
        this.purpleOrb = orb;
    }

    @Override
    public int alexcaveaddon_getClientSkillId() {
        return this.clientSkillId;
    }

    @Override
    public int alexcaveaddon_getClientSkillTicks() {
        return this.clientSkillTicks;
    }

    @Override
    public float alexcaveaddon_getPartialTick() {
        return this.partialTick;
    }

    @Override
    public void alexcaveaddon_setPartialTick(float partialTick) {
        this.partialTick = partialTick;
    }
}

