/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.entity.ability;

import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.undying.alex_cave_addon.client.animation.PlayerAnimations;
import net.undying.alex_cave_addon.entity.ModEntities;
import net.undying.alex_cave_addon.entity.ability.ISkill;
import net.undying.alex_cave_addon.entity.ability.PlayerAccess;
import net.undying.alex_cave_addon.entity.projectile.MagneticOrbEntity;

public class PurpleOrbSkill
implements ISkill {
    @Override
    public void onStart(Player player) {
    }

    @Override
    public void tick(Player player, int ticks) {
        if (ticks == 5) {
            for (int i = 0; i < 2; ++i) {
                MagneticOrbEntity orb = new MagneticOrbEntity((EntityType<MagneticOrbEntity>)((EntityType)ModEntities.MAGNETIC_ORB.get()), player.m_9236_());
                orb.m_5602_((Entity)player);
                orb.setOrbType(i);
                orb.setDisplay(true);
                orb.setGrow(7, false);
                PlayerAccess.setOrb(player, i, orb);
                if (i == 0) {
                    this.positionRedOrb(player, orb, ticks);
                } else {
                    this.positionBlueOrb(player, orb, ticks);
                }
                player.m_9236_().m_7967_((Entity)orb);
            }
            this.playSound((Entity)player, SoundEvents.f_12616_, 1.0f, 1.0f);
        }
        MagneticOrbEntity redOrb = PlayerAccess.getOrb(player, 0);
        MagneticOrbEntity blueOrb = PlayerAccess.getOrb(player, 1);
        MagneticOrbEntity purpleOrb = PlayerAccess.getOrb(player, 2);
        if (ticks > 5 && ticks < 35) {
            if (redOrb != null) {
                this.positionRedOrb(player, redOrb, ticks);
            }
            if (blueOrb != null) {
                this.positionBlueOrb(player, blueOrb, ticks);
            }
        }
        if (ticks == 25) {
            if (redOrb != null) {
                redOrb.setGrow(10, true);
            }
            if (blueOrb != null) {
                blueOrb.setGrow(10, true);
            }
        }
        if (ticks == 35) {
            if (redOrb != null) {
                redOrb.m_146870_();
                PlayerAccess.setOrb(player, 0, null);
            }
            if (blueOrb != null) {
                blueOrb.m_146870_();
                PlayerAccess.setOrb(player, 1, null);
            }
        }
        if (ticks == 40) {
            purpleOrb = new MagneticOrbEntity((EntityType<MagneticOrbEntity>)((EntityType)ModEntities.MAGNETIC_ORB.get()), player.m_9236_());
            purpleOrb.m_5602_((Entity)player);
            purpleOrb.setOrbType(2);
            purpleOrb.setSize(1.5f);
            purpleOrb.setDisplay(true);
            purpleOrb.setGrow(7, false);
            this.positionPurpleOrb(player, purpleOrb);
            PlayerAccess.setOrb(player, 2, purpleOrb);
            player.m_9236_().m_7967_((Entity)purpleOrb);
        }
        if (ticks > 40 && ticks < 48 && purpleOrb != null) {
            this.positionPurpleOrb(player, purpleOrb);
        }
        if (ticks == 48) {
            if (purpleOrb != null) {
                purpleOrb.m_37251_((Entity)player, player.m_146909_(), player.f_20885_, 0.0f, 1.0f, 0.0f);
                purpleOrb.setDisplay(false);
                this.playSound((Entity)player, SoundEvents.f_11739_, 1.0f, 1.0f);
            }
            PlayerAccess.setOrb(player, 2, null);
        }
        PlayerAccess.rotateBody(player);
    }

    @Override
    public void onEnd(Player player, boolean finished) {
        for (int i = 0; i < 3; ++i) {
            MagneticOrbEntity orb = PlayerAccess.getOrb(player, i);
            if (orb != null) {
                orb.m_146870_();
            }
            PlayerAccess.setOrb(player, i, null);
        }
    }

    protected void positionRedOrb(Player player, MagneticOrbEntity entity, int ticks) {
        Vec3 pos = player.m_146892_();
        float f = 1.0f - Mth.m_14036_((float)((float)(ticks - 5) / 30.0f), (float)0.0f, (float)1.0f);
        float f1 = player.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f;
        pos = pos.m_82549_(Vec3.m_82498_((float)0.0f, (float)(player.f_20883_ + f1)).m_82490_((double)f));
        pos = pos.m_82549_(Vec3.m_82498_((float)0.0f, (float)(player.f_20883_ - 180.0f)));
        entity.m_146884_(pos.m_82492_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
        entity.m_20256_(Vec3.f_82478_);
    }

    protected void positionBlueOrb(Player player, MagneticOrbEntity entity, int ticks) {
        Vec3 pos = player.m_146892_();
        float f = 1.0f - Mth.m_14036_((float)((float)(ticks - 5) / 30.0f), (float)0.0f, (float)1.0f);
        float f1 = player.m_5737_() == HumanoidArm.RIGHT ? -90.0f : 90.0f;
        pos = pos.m_82549_(Vec3.m_82498_((float)0.0f, (float)(player.f_20883_ + f1)).m_82490_((double)f));
        pos = pos.m_82549_(Vec3.m_82498_((float)0.0f, (float)(player.f_20883_ - 180.0f)));
        entity.m_146884_(pos.m_82492_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
        entity.m_20256_(Vec3.f_82478_);
    }

    protected void positionPurpleOrb(Player player, MagneticOrbEntity entity) {
        Vec3 pos = player.m_146892_();
        pos = pos.m_82549_(Vec3.m_82498_((float)0.0f, (float)player.f_20883_).m_82490_(1.5));
        entity.m_146884_(pos.m_82492_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
        entity.m_20256_(Vec3.f_82478_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AnimationDefinition getAnimation(Player player) {
        return PlayerAnimations.PURPLE_ORB;
    }
}

