/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.me;

import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.CellState;
import appeng.api.upgrades.IUpgradeableItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public interface IAEUniversalCell
extends IUpgradeableItem {
    public static final String CELL_STATE_TAG_NAME = "ae_universal_cell_state";
    public static final String CELL_BYTES_USAGE_TAG_NAME = "ae_universal_cell_bytes_usage";
    public static final String CELL_TYPES_USAGE_TAG_NAME = "ae_universal_cell_types_usage";
    public static final String CELL_SHOW_TOOLTIP_STACKS_TAG_NAME = "ae_universal_cell_show_tooltip_stacks";

    public int getTotalBytes();

    public int getTotalTypes();

    public double getIdleDrain();

    public static long getUsedBytes(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0L;
        }
        if (tag.m_128441_(CELL_BYTES_USAGE_TAG_NAME)) {
            return tag.m_128454_(CELL_BYTES_USAGE_TAG_NAME);
        }
        return 0L;
    }

    public static void setUsedBytes(ItemStack stack, long usedBytes) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(CELL_BYTES_USAGE_TAG_NAME, Math.max(0L, usedBytes));
    }

    public static int getUsedTypes(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0;
        }
        if (tag.m_128441_(CELL_TYPES_USAGE_TAG_NAME)) {
            return tag.m_128451_(CELL_TYPES_USAGE_TAG_NAME);
        }
        return 0;
    }

    public static void setUsedTypes(ItemStack stack, int usedTypes) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(CELL_TYPES_USAGE_TAG_NAME, Math.max(0, usedTypes));
    }

    public static CellState getCellState(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return CellState.EMPTY;
        }
        if (tag.m_128441_(CELL_STATE_TAG_NAME)) {
            return CellState.valueOf((String)tag.m_128461_(CELL_STATE_TAG_NAME));
        }
        return CellState.EMPTY;
    }

    public static void setCellState(ItemStack stack, IAEUniversalCell cellType, long usedBytes, int usedTypes) {
        int totalBytes = cellType.getTotalBytes();
        int totalTypes = cellType.getTotalTypes();
        CellState state = usedBytes <= 0L && usedTypes <= 0 ? CellState.EMPTY : (totalBytes > 0 && usedBytes >= (long)totalBytes ? CellState.FULL : (totalTypes > 0 && usedTypes >= totalTypes ? CellState.TYPES_FULL : CellState.NOT_EMPTY));
        stack.m_41784_().m_128359_(CELL_STATE_TAG_NAME, state.name());
    }

    public static List<GenericStack> getTooltipShowStacks(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return List.of();
        }
        ListTag list = tag.m_128437_(CELL_SHOW_TOOLTIP_STACKS_TAG_NAME, 10);
        if (list.isEmpty()) {
            return List.of();
        }
        ArrayList<GenericStack> out = new ArrayList<GenericStack>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            GenericStack genericStack = GenericStack.readTag((CompoundTag)entry);
            if (genericStack == null) continue;
            out.add(genericStack);
        }
        return Collections.unmodifiableList(out);
    }

    public static void setTooltipShowStacks(ItemStack stack, List<GenericStack> showStacks) {
        if (showStacks == null || showStacks.isEmpty()) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_(CELL_SHOW_TOOLTIP_STACKS_TAG_NAME);
            }
            return;
        }
        ListTag list = new ListTag();
        for (GenericStack gs : showStacks) {
            if (gs == null) continue;
            list.add((Object)GenericStack.writeTag((GenericStack)gs));
        }
        stack.m_41784_().m_128365_(CELL_SHOW_TOOLTIP_STACKS_TAG_NAME, (Tag)list);
    }
}

