/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells;

import com.mojang.logging.LogUtils;
import com.wintercogs.ae2omnicells.AE2OmniCellsClient;
import com.wintercogs.ae2omnicells.Config;
import com.wintercogs.ae2omnicells.common.init.OCBlocks;
import com.wintercogs.ae2omnicells.common.init.OCCreativeModeTabs;
import com.wintercogs.ae2omnicells.common.init.OCItems;
import com.wintercogs.ae2omnicells.common.init.OCMenus;
import com.wintercogs.ae2omnicells.common.me.AEPlugin;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="ae2omnicells")
public class AE2OmniCells {
    public static final String MODID = "ae2omnicells";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MEGA_MODID = "megacells";
    public static boolean MEGA_LOADED = false;
    public static final String EAE_MODID = "expatternprovider";
    public static boolean EAE_LOADED = false;
    public static final String AAE_MODID = "advanced_ae";
    public static boolean AAE_LOADED = false;

    public AE2OmniCells() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::constructMod);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        OCItems.register(modEventBus);
        OCBlocks.register(modEventBus);
        OCCreativeModeTabs.register(modEventBus);
        OCMenus.registerMenus(modEventBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            AE2OmniCellsClient.clientInit();
            AE2OmniCellsClient.clientRegister(modEventBus, MinecraftForge.EVENT_BUS);
        }
    }

    private void constructMod(FMLConstructModEvent event) {
        if (ModList.get().isLoaded(MEGA_MODID)) {
            MEGA_LOADED = true;
        }
        if (ModList.get().isLoaded(EAE_MODID)) {
            EAE_LOADED = true;
        }
        if (ModList.get().isLoaded(AAE_MODID)) {
            AAE_LOADED = true;
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AEPlugin.register();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            AE2OmniCellsClient.clientCommonSetup();
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("AE2OmniCells - Server started");
    }

    public static ResourceLocation makeId(String path) {
        return new ResourceLocation(MODID, path);
    }

    @Mod.EventBusSubscriber(modid="ae2omnicells", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("AE2OmniCells - Client started");
        }
    }
}

