/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.flexible.standard.nodes.intervalfn;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.queries.intervals.Intervals;
import guideme.internal.shaded.lucene.queries.intervals.IntervalsSource;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;
import java.util.Locale;
import java.util.Objects;

public class MaxGaps
extends IntervalFunction {
    private final int maxGaps;
    private final IntervalFunction source;

    public MaxGaps(int maxGaps, IntervalFunction source) {
        this.maxGaps = maxGaps;
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.maxgaps(this.maxGaps, this.source.toIntervalSource(field, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:maxgaps(%s %s)", this.maxGaps, this.source);
    }
}

