/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.facet.FacetsConfig;
import guideme.internal.shaded.lucene.facet.TopOrdAndFloatNumberQueue;
import guideme.internal.shaded.lucene.facet.TopOrdAndNumberQueue;
import guideme.internal.shaded.lucene.facet.taxonomy.AssociationAggregationFunction;
import guideme.internal.shaded.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyFacets;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyReader;
import guideme.internal.shaded.lucene.internal.hppc.IntFloatHashMap;
import java.io.IOException;

@Deprecated
public abstract class FloatTaxonomyFacets
extends TaxonomyFacets {
    protected final AssociationAggregationFunction aggregationFunction;
    protected float[] values;
    IntFloatHashMap sparseValues;

    protected FloatTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.aggregationFunction = AssociationAggregationFunction.SUM;
        this.values = new float[taxoReader.getSize()];
    }

    protected FloatTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, AssociationAggregationFunction aggregationFunction, FacetsConfig config, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config, fc);
        this.aggregationFunction = aggregationFunction;
        this.valueComparator = (o1, o2) -> Float.compare(o1.floatValue(), o2.floatValue());
    }

    @Override
    protected void initializeValueCounters() {
        if (this.initialized) {
            return;
        }
        super.initializeValueCounters();
        assert (this.sparseValues == null && this.values == null);
        if (this.sparseCounts != null) {
            this.sparseValues = new IntFloatHashMap();
        } else {
            this.values = new float[this.taxoReader.getSize()];
        }
    }

    void setValue(int ordinal, float newValue) {
        if (this.sparseValues != null) {
            this.sparseValues.put(ordinal, newValue);
        } else {
            this.values[ordinal] = newValue;
        }
    }

    float getValue(int ordinal) {
        if (this.sparseValues != null) {
            return this.sparseValues.get(ordinal);
        }
        return this.values[ordinal];
    }

    @Override
    protected Number getAggregationValue(int ordinal) {
        return Float.valueOf(this.getValue(ordinal));
    }

    @Override
    protected Number aggregate(Number existingVal, Number newVal) {
        return Float.valueOf(this.aggregationFunction.aggregate(existingVal.floatValue(), newVal.floatValue()));
    }

    @Override
    protected void updateValueFromRollup(int ordinal, int childOrdinal) throws IOException {
        super.updateValueFromRollup(ordinal, childOrdinal);
        float currentValue = this.getValue(ordinal);
        float newValue = this.aggregationFunction.aggregate(currentValue, this.rollup(childOrdinal));
        this.setValue(ordinal, newValue);
    }

    @Override
    protected TopOrdAndNumberQueue makeTopOrdAndNumberQueue(int topN) {
        return new TopOrdAndFloatNumberQueue(Math.min(this.taxoReader.getSize(), topN));
    }

    @Override
    protected Number missingAggregationValue() {
        return Float.valueOf(-1.0f);
    }

    private float rollup(int ord) throws IOException {
        ParallelTaxonomyArrays.IntArray children = this.getChildren();
        ParallelTaxonomyArrays.IntArray siblings = this.getSiblings();
        float aggregatedValue = 0.0f;
        while (ord != -1) {
            this.updateValueFromRollup(ord, children.get(ord));
            aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, this.getValue(ord));
            ord = siblings.get(ord);
        }
        return aggregatedValue;
    }

    @Override
    protected void setIncomingValue(TopOrdAndNumberQueue.OrdAndValue incomingOrdAndValue, int ord) {
        ((TopOrdAndFloatNumberQueue.OrdAndFloat)incomingOrdAndValue).value = this.getValue(ord);
    }

    @Override
    protected TaxonomyFacets.AggregatedValue newAggregatedValue() {
        return new FloatAggregatedValue(0.0f);
    }

    protected class FloatAggregatedValue
    extends TaxonomyFacets.AggregatedValue {
        private float value;

        public FloatAggregatedValue(float value) {
            this.value = value;
        }

        @Override
        public void aggregate(int ord) {
            this.value = FloatTaxonomyFacets.this.aggregationFunction.aggregate(this.value, FloatTaxonomyFacets.this.getValue(ord));
        }

        @Override
        public Number get() {
            return Float.valueOf(this.value);
        }
    }
}

