/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.document.SortedNumericDocValuesRangeQuery;
import guideme.internal.shaded.lucene.document.SortedNumericDocValuesSetQuery;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.search.Query;

public class NumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public NumericDocValuesField(String name, long value) {
        this(name, (Long)value);
    }

    public NumericDocValuesField(String name, Long value) {
        super(name, TYPE);
        this.fieldsData = value;
    }

    public static Query newSlowRangeQuery(String field, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field, lowerValue, upperValue);
    }

    public static Query newSlowSetQuery(String field, long ... values) {
        return new SortedNumericDocValuesSetQuery(field, (long[])values.clone());
    }

    public static Query newSlowExactQuery(String field, long value) {
        return NumericDocValuesField.newSlowRangeQuery(field, value, value);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.NUMERIC);
        TYPE.freeze();
    }
}

