/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ItemShelfBlock;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FlowerBoxBlockTile
extends ItemDisplayTile
implements IBlockHolder,
IExtraModelDataProvider {
    public static final ModelDataKey<BlockState> FLOWER_0 = ModBlockProperties.FLOWER_0;
    public static final ModelDataKey<BlockState> FLOWER_1 = ModBlockProperties.FLOWER_1;
    public static final ModelDataKey<BlockState> FLOWER_2 = ModBlockProperties.FLOWER_2;
    private final BlockState[] flowerStates = new BlockState[]{Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_()};

    public FlowerBoxBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.FLOWER_BOX_TILE.get(), pos, state, 3);
    }

    public BlockState getHeldBlock(int index) {
        return this.flowerStates[index];
    }

    public boolean setHeldBlock(BlockState state, int index) {
        if (index >= 0 && index < 3) {
            this.flowerStates[index] = state;
        }
        return false;
    }

    public void m_6836_(int slot, ItemStack stack) {
        super.m_6836_(slot, stack);
        if (this.f_58857_ instanceof ServerLevel) {
            this.setBlockFromItem(slot, stack.m_41720_());
            int newLight = Math.max(Math.max(ForgeHelper.getLightEmission((BlockState)this.getHeldBlock(), (Level)this.f_58857_, (BlockPos)this.f_58858_), ForgeHelper.getLightEmission((BlockState)this.getHeldBlock(1), (Level)this.f_58857_, (BlockPos)this.f_58858_)), ForgeHelper.getLightEmission((BlockState)this.getHeldBlock(2), (Level)this.f_58857_, (BlockPos)this.f_58858_));
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FrameBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight)), 3);
        }
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(FLOWER_0, (Object)this.flowerStates[0]).with(FLOWER_1, (Object)this.flowerStates[1]).with(FLOWER_2, (Object)this.flowerStates[2]);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82386_(0.0, 0.25, 0.0);
    }

    public void updateClientVisualsOnLoad() {
        for (int n = 0; n < this.flowerStates.length; ++n) {
            Item item = this.m_8020_(n).m_41720_();
            this.setBlockFromItem(n, item);
        }
        this.requestModelReload();
    }

    private void setBlockFromItem(int n, Item item) {
        Block b = null;
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            b = bi.m_40614_();
        } else if (CompatHandler.DYNAMICTREES) {
            b = CompatHandler.DynTreesGetOptionalDynamicSapling(item, this.f_58857_, this.f_58858_);
        }
        if (b == null) {
            b = Blocks.f_50016_;
        }
        this.flowerStates[n] = b.m_49966_();
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"block.supplementaries.flower_box");
    }

    public float getYaw() {
        return -this.getDirection().m_122424_().m_122435_();
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)ItemShelfBlock.FACING);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (this.m_8020_(index).m_41619_()) {
            if (FlowerPotHandler.hasSpecialFlowerModel(stack.m_41720_())) {
                return true;
            }
            if (CommonConfigs.Building.FLOWER_BOX_SIMPLE_MODE.get().booleanValue()) {
                return false;
            }
            return stack.m_41720_() instanceof BlockItem && stack.m_204117_(ModTags.FLOWER_BOX_PLANTABLE);
        }
        return false;
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.f_11839_;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return null;
    }
}

