/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class CannonChargeHud {
    protected final Minecraft mc;

    protected CannonChargeHud(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void render(GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        if (!this.mc.f_91066_.f_92062_ && CannonController.isActive()) {
            this.setupOverlayRenderState();
            ResourceLocation texture = ModTextures.CANNON_ICONS_TEXTURE;
            CannonBlockTile cannon = CannonController.cannon;
            this.renderHotBar(graphics, screenWidth, screenHeight, texture, cannon);
            CannonChargeHud.renderCrossHair(graphics, screenWidth, screenHeight, texture);
            this.renderBar(graphics, screenWidth, screenHeight, texture, cannon, partialTicks);
            CannonChargeHud.renderTrajectoryIcons(graphics, screenWidth, screenHeight, texture);
        }
    }

    private static void renderTrajectoryIcons(GuiGraphics graphics, int screenWidth, int screenHeight, ResourceLocation texture) {
        int iconLeft = screenWidth / 2 + 96;
        int iconTop = screenHeight - 22;
        int iconW = 14;
        int iconU = CannonController.shootingMode.ordinal() * iconW;
        graphics.m_280218_(texture, iconLeft, iconTop, iconU, 42, iconW, iconW);
        iconLeft = screenWidth / 2 - 110;
        iconU = CannonController.showsTrajectory ? 0 : 14;
        graphics.m_280218_(texture, iconLeft, iconTop, iconU, 56, iconW, iconW);
    }

    private void renderHotBar(GuiGraphics graphics, int screenWidth, int screenHeight, ResourceLocation texture, CannonBlockTile cannon) {
        int left = screenWidth / 2 - 91;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, -90.0f);
        graphics.m_280218_(texture, left, screenHeight - 22, 0, 19, 182, 22);
        graphics.m_280168_().m_85849_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int k2 = screenHeight - 16 - 3;
        this.renderSlot(graphics, left + 1 + 47 + 2, k2, (Player)player, cannon.getProjectile(), 1);
        this.renderSlot(graphics, left + 1 + 113 + 2, k2, (Player)player, cannon.getFuel(), 1);
    }

    private void renderBar(GuiGraphics graphics, int screenWidth, int screenHeight, ResourceLocation texture, CannonBlockTile cannon, float partialTicks) {
        int xpBarLeft = screenWidth / 2 - 91;
        float c = 1.0f - cannon.getCooldownAnimation(partialTicks);
        int k = (int)(c * 183.0f);
        int xpBarTop = screenHeight - 32 + 3;
        graphics.m_280218_(texture, xpBarLeft, xpBarTop, 0, 0, 182, 5);
        float f = cannon.getFiringAnimation(partialTicks);
        float min = 0.7f;
        if (f > 0.0f) {
            f = 1.0f - f;
            float red = f * 0.4f + min;
            float green = min - f * 0.4f * min;
            float blue = min;
            RenderSystem.setShaderColor((float)red, (float)green, (float)(min - f * blue), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)min, (float)min, (float)min, (float)1.0f);
        }
        graphics.m_280218_(texture, xpBarLeft, xpBarTop, 0, 5, k, 5);
        byte power = CannonController.cannon.getPowerLevel();
        int color = switch (power) {
            case 2 -> 0xFFAA00;
            case 3 -> 0xFF8800;
            case 4 -> 0xFF6600;
            default -> 0xFFCC00;
        };
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String s = String.valueOf(power);
        int i1 = (screenWidth - this.mc.f_91062_.m_92895_(s)) / 2;
        int j1 = screenHeight - 31 - 4;
        graphics.m_280056_(this.mc.f_91062_, s, i1 + 1, j1, 0, false);
        graphics.m_280056_(this.mc.f_91062_, s, i1 - 1, j1, 0, false);
        graphics.m_280056_(this.mc.f_91062_, s, i1, j1 + 1, 0, false);
        graphics.m_280056_(this.mc.f_91062_, s, i1, j1 - 1, 0, false);
        graphics.m_280056_(this.mc.f_91062_, s, i1, j1, color, false);
    }

    private static void renderCrossHair(GuiGraphics graphics, int screenWidth, int screenHeight, ResourceLocation texture) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, -90.0f);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int w = 9;
        int hitType = CannonController.shootingMode == ShootingMode.STRAIGHT ? 6 : (CannonController.trajectory == null || CannonController.trajectory.miss() ? 2 : 0);
        graphics.m_280218_(texture, (screenWidth - w) / 2, (screenHeight - w) / 2, hitType * w, 10, w, w);
        RenderSystem.defaultBlendFunc();
        graphics.m_280168_().m_85849_();
    }

    public void setupOverlayRenderState() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
    }

    private void renderSlot(GuiGraphics guiGraphics, int x, int y, Player player, ItemStack itemStack, int seed) {
        if (!itemStack.m_41619_()) {
            guiGraphics.m_280638_((LivingEntity)player, itemStack, x, y, seed);
            guiGraphics.m_280370_(this.mc.f_91062_, itemStack, x, y);
        }
    }
}

