/*
 * Decompiled with CFR 0.152.
 */
package top.qm.industrialplatform.block.custom.platform;

import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.qm.industrialplatform.IPTags;
import top.qm.industrialplatform.block.state.properties.platform.PlatformMode;
import top.qm.industrialplatform.block.state.properties.platform.PlatformProperties;

@Mod.EventBusSubscriber(modid="industrial_platform", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class IndustrialPlatformBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final EnumProperty PLATFORM_MODE = PlatformProperties.PLATFORM_MODE;
    private static final BooleanProperty FLOATING = PlatformProperties.FLOATING;

    public IndustrialPlatformBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152589_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLOATING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PLATFORM_MODE, (Comparable)((Object)PlatformMode.INDUSTRIAL_LIGHT)));
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PLATFORM_MODE});
        builder.m_61104_(new Property[]{FLOATING});
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos blockPos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.m_21120_(hand);
        BlockState state = level.m_8055_(blockPos);
        if (level.m_5776_() || !(state.m_60734_() instanceof IndustrialPlatformBlock)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (heldItem.m_41619_() && hand == InteractionHand.MAIN_HAND && player.m_6047_()) {
            serverLevel.m_7731_(blockPos, (BlockState)state.m_61122_((Property)FLOATING), 3);
            player.m_21011_(InteractionHand.MAIN_HAND, true);
        } else if (heldItem.m_41619_() && hand == InteractionHand.MAIN_HAND) {
            serverLevel.m_7731_(blockPos, (BlockState)state.m_61122_((Property)PLATFORM_MODE), 3);
            player.m_21011_(InteractionHand.MAIN_HAND, true);
        } else if (heldItem.m_204117_(IPTags.Items.STONE) && hand == InteractionHand.MAIN_HAND) {
            int posX = blockPos.m_123341_();
            int posY = blockPos.m_123342_();
            int posZ = blockPos.m_123343_();
            int finX = (int)Math.floor((double)posX / 16.0) * 16;
            int finZ = (int)Math.floor((double)posZ / 16.0) * 16;
            if (((Boolean)state.m_61143_((Property)FLOATING)).booleanValue()) {
                if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.INDUSTRIAL_LIGHT) {
                    IndustrialPlatformBlock.placeStructure(serverLevel, finX, posY, finZ, "industrial");
                } else if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.INDUSTRIAL_HEAVY) {
                    IndustrialPlatformBlock.placeExtendedStructure(serverLevel, finX, posY, finZ, "industrial");
                } else if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.CHECKERBOARD_LIGHT) {
                    IndustrialPlatformBlock.placeStructure(serverLevel, finX, posY, finZ, "checkerboard");
                } else if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.CHECKERBOARD_HEAVY) {
                    IndustrialPlatformBlock.placeExtendedStructure(serverLevel, finX, posY, finZ, "checkerboard");
                } else if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.POOL) {
                    if (posY <= 0) {
                        MutableComponent failKey = Component.m_237115_((String)"message.industrial_platform.too_low").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                        player.m_5661_((Component)failKey, true);
                        return;
                    }
                    IndustrialPlatformBlock.placeStructure(serverLevel, finX, posY - 31, finZ, "pool_top");
                    IndustrialPlatformBlock.placeStructure(serverLevel, finX, posY - 63, finZ, "pool_bottom");
                }
            } else if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.INDUSTRIAL_LIGHT) {
                IndustrialPlatformBlock.fillArea(serverLevel, finX, posY + 1, finZ, finX + 15, posY + 11, finZ + 15);
                IndustrialPlatformBlock.fillAreaConditional(serverLevel, finX, posY - 11, finZ, finX + 15, posY - 1, finZ + 15);
                IndustrialPlatformBlock.placeStructure(serverLevel, finX, posY, finZ, "industrial");
            } else if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.INDUSTRIAL_HEAVY) {
                IndustrialPlatformBlock.fillArea(serverLevel, finX - 16, posY + 1, finZ - 16, finX + 31, posY + 11, finZ + 31);
                IndustrialPlatformBlock.fillAreaConditional(serverLevel, finX - 16, posY - 11, finZ - 16, finX + 31, posY - 1, finZ + 31);
                IndustrialPlatformBlock.placeExtendedStructure(serverLevel, finX, posY, finZ, "industrial");
            } else if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.CHECKERBOARD_LIGHT) {
                IndustrialPlatformBlock.fillArea(serverLevel, finX, posY + 1, finZ, finX + 15, posY + 11, finZ + 15);
                IndustrialPlatformBlock.fillAreaConditional(serverLevel, finX, posY - 11, finZ, finX + 15, posY - 1, finZ + 15);
                IndustrialPlatformBlock.placeStructure(serverLevel, finX, posY, finZ, "checkerboard");
            } else if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.CHECKERBOARD_HEAVY) {
                IndustrialPlatformBlock.fillArea(serverLevel, finX - 16, posY + 1, finZ - 16, finX + 31, posY + 11, finZ + 31);
                IndustrialPlatformBlock.fillAreaConditional(serverLevel, finX - 16, posY - 11, finZ - 16, finX + 31, posY - 1, finZ + 31);
                IndustrialPlatformBlock.placeExtendedStructure(serverLevel, finX, posY, finZ, "checkerboard");
            } else if (state.m_61143_((Property)PLATFORM_MODE) == PlatformMode.POOL) {
                if (posY <= 0) {
                    MutableComponent failKey = Component.m_237115_((String)"message.industrial_platform.too_low").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                    player.m_5661_((Component)failKey, true);
                    return;
                }
                IndustrialPlatformBlock.fillArea(serverLevel, finX, posY + 1, finZ, finX + 15, posY + 11, finZ + 15);
                IndustrialPlatformBlock.placeStructure(serverLevel, finX, posY - 31, finZ, "pool_top");
                IndustrialPlatformBlock.placeStructure(serverLevel, finX, posY - 63, finZ, "pool_bottom");
            }
            MutableComponent successfulKey = Component.m_237115_((String)"message.industrial_platform.done").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
            player.m_5661_((Component)successfulKey, true);
            IndustrialPlatformBlock.consumeItem(player, heldItem, hand);
            event.setCanceled(true);
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    private static void fillArea(ServerLevel level, int x0, int y0, int z0, int x1, int y1, int z1) {
        for (int x = x0; x <= x1; ++x) {
            for (int y = y0; y <= y1; ++y) {
                for (int z = z0; z <= z1; ++z) {
                    level.m_46597_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    private static void fillAreaConditional(ServerLevel level, int x0, int y0, int z0, int x1, int y1, int z1) {
        for (int x = x0; x <= x1; ++x) {
            for (int y = y0; y <= y1; ++y) {
                for (int z = z0; z <= z1; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    if (!state.m_60795_() && state.m_60819_().m_76178_()) continue;
                    level.m_46597_(pos, Blocks.f_50069_.m_49966_());
                }
            }
        }
    }

    private static void placeStructure(ServerLevel level, int x, int y, int z, String structureId) {
        StructureTemplateManager manager = level.m_215082_();
        ResourceLocation structureName = ResourceLocation.parse((String)("industrial_platform:industrial_platform/" + structureId));
        Optional template = manager.m_230407_(structureName);
        template.ifPresent(temp -> temp.m_230328_((ServerLevelAccessor)level, new BlockPos(x, y, z), new BlockPos(x, y, z), new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74392_(false), level.f_46441_, 3));
    }

    private static void placeExtendedStructure(ServerLevel level, int x, int y, int z, String structureId) {
        StructureTemplateManager manager = level.m_215082_();
        ResourceLocation structureName = ResourceLocation.parse((String)("industrial_platform:industrial_platform/" + structureId));
        Optional template = manager.m_230407_(structureName);
        for (int i = x - 16; i <= x + 16; i += 16) {
            for (int j = z - 16; j <= z + 16; j += 16) {
                int finalI = i;
                int finalJ = j;
                template.ifPresent(temp -> temp.m_230328_((ServerLevelAccessor)level, new BlockPos(finalI, y, finalJ), new BlockPos(finalI, y, finalJ), new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74392_(false), level.f_46441_, 3));
            }
        }
    }

    private static void consumeItem(Player player, ItemStack stack, InteractionHand hand) {
        player.m_6674_(hand);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos blockPos, PathComputationType type) {
        return false;
    }
}

