/*
 * Decompiled with CFR 0.152.
 */
package com.sswltzz.tetracompat.integration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import se.mickelus.tetracelium.compat.farmersdelight.FarmersDelightToolActions;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ToolActionIngredient;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class FarmersDelightCompat {
    public static void injectRecipes(Map<ResourceLocation, Recipe<?>> recipes, BiConsumer<ResourceLocation, Recipe<?>> add) {
        Map<ResourceLocation, CuttingBoardRecipe> cuttingRecipes = recipes.entrySet().stream().filter(resourceLocationRecipeEntry -> resourceLocationRecipeEntry.getValue() instanceof CuttingBoardRecipe).filter(resourceLocationRecipeEntry -> !((ResourceLocation)resourceLocationRecipeEntry.getKey()).m_135827_().equals("farmersdelight")).filter(resourceLocationRecipeEntry -> !((ResourceLocation)resourceLocationRecipeEntry.getKey()).m_135827_().equals("tetracelium")).filter(resourceLocationRecipeEntry -> {
            JsonObject toolJson = (JsonObject)((CuttingBoardRecipe)resourceLocationRecipeEntry.getValue()).getTool().m_43942_();
            JsonElement tagElement = toolJson.get("tag");
            return tagElement != null && tagElement.getAsString().equals("forge:tools/knives");
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> (CuttingBoardRecipe)entry.getValue()));
        cuttingRecipes.forEach((originalID, recipe) -> {
            ResourceLocation id = new ResourceLocation("tetracompat", String.format("tetracelium_%s_from_%s", originalID.m_135815_(), originalID.m_135827_()));
            NonNullList chanceResults = recipe.getRollableResults();
            Ingredient ingredient = Ingredient.merge((Collection)recipe.m_7527_());
            CuttingBoardRecipe cuttingBoardRecipe = new CuttingBoardRecipe(id, "", ingredient, (Ingredient)new ToolActionIngredient(FarmersDelightToolActions.bladeCut), chanceResults, ModSounds.BLOCK_CUTTING_BOARD_KNIFE.getId().toString());
            add.accept(id, (Recipe<?>)cuttingBoardRecipe);
        });
    }
}

