/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic.requirement;

import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.schematic.CraftingContext;
import se.mickelus.tetra.module.schematic.requirement.CraftingRequirement;
import se.mickelus.tetra.module.schematic.requirement.IntegerPredicate;

public class HasImprovementRequirement
implements CraftingRequirement {
    String improvement;
    IntegerPredicate level;

    @Override
    public boolean test(CraftingContext context) {
        if (context.targetMajorModule != null) {
            if (this.level != null && !this.level.test(context.targetMajorModule.getImprovementLevel(context.targetStack, this.improvement))) {
                return false;
            }
            return context.targetMajorModule.getImprovement(context.targetStack, this.improvement) != null;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public List<Component> getDescription() {
        if (this.level != null) {
            return List.of(Component.m_237113_((String)I18n.m_118938_((String)"tetra.holo.improvement_requirement_level", (Object[])new Object[]{IModularItem.getImprovementName(this.improvement, 0), this.level.getDescription(I18n.m_118938_((String)"tetra.holo.improvement_requirement_level.level_label", (Object[])new Object[0]))})));
        }
        return List.of(Component.m_237113_((String)I18n.m_118938_((String)"tetra.holo.improvement_requirement", (Object[])new Object[]{IModularItem.getImprovementName(this.improvement, 0)})));
    }
}

