/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import se.mickelus.tetra.aspect.TetraEnchantmentHelper;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.ImprovementData;

@ParametersAreNonnullByDefault
public class TetraCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"tetra").requires(player -> player.m_6761_(2));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hone").executes(ctx -> TetraCommand.runHone((CommandContext<CommandSourceStack>)ctx, 100))).then(Commands.m_82129_((String)"progress", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(ctx -> TetraCommand.runHone((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"progress")))));
        command.then(Commands.m_82127_((String)"module").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"slot", (ArgumentType)StringArgumentType.string()).suggests(TetraCommand::getAllSlotSuggestions).then(Commands.m_82127_((String)"remove").executes(ctx -> TetraCommand.runRemoveModule((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"slot"))))).then(Commands.m_82129_((String)"module", (ArgumentType)StringArgumentType.string()).suggests(TetraCommand::getModuleSuggestions).then(Commands.m_82129_((String)"variant", (ArgumentType)StringArgumentType.string()).suggests(TetraCommand::getVariantSuggestions).executes(ctx -> TetraCommand.runAddModule((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"slot"), StringArgumentType.getString((CommandContext)ctx, (String)"module"), StringArgumentType.getString((CommandContext)ctx, (String)"variant")))))));
        command.then(Commands.m_82127_((String)"improvement").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"slot", (ArgumentType)StringArgumentType.string()).suggests(TetraCommand::getMajorSlotSuggestions).then(Commands.m_82127_((String)"clear").executes(ctx -> TetraCommand.runClearImprovements((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"slot"))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"improvement", (ArgumentType)StringArgumentType.string()).suggests(TetraCommand::getCurrentImprovementSuggestion).executes(ctx -> TetraCommand.runRemoveImprovement((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"slot"), StringArgumentType.getString((CommandContext)ctx, (String)"improvement")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"improvement", (ArgumentType)StringArgumentType.string()).suggests(TetraCommand::getAvailableImprovementSuggestion).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).suggests(TetraCommand::getImprovementLevelSuggestion).executes(ctx -> TetraCommand.runAddImprovement((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"slot"), StringArgumentType.getString((CommandContext)ctx, (String)"improvement"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level"))))))));
        command.then(Commands.m_82127_((String)"enchantment").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"slot", (ArgumentType)StringArgumentType.string()).suggests(TetraCommand::getMajorSlotSuggestions).then(Commands.m_82127_((String)"clear").executes(ctx -> TetraCommand.runClearEnchantments((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"slot"))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"enchantment", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256762_)).suggests(TetraCommand::getCurrentEnchantmentsSuggestion).executes(ctx -> TetraCommand.runRemoveEnchantment((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"slot"), (Holder<Enchantment>)ResourceArgument.m_245369_((CommandContext)ctx, (String)"enchantment")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"enchantment", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256762_)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).suggests(TetraCommand::getEnchantmentLevelSuggestion).executes(ctx -> TetraCommand.runAddEnchantment((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"slot"), (Holder<Enchantment>)ResourceArgument.m_245369_((CommandContext)ctx, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level"))))))));
        dispatcher.register(command);
    }

    private static int runHone(CommandContext<CommandSourceStack> context, int progress) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = TetraCommand.getItemStackOrReplacement((Player)player);
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            if (item2.canGainHoneProgress(itemStack)) {
                item2.setHoningProgress(itemStack, (int)Math.ceil((float)(100 - progress) / 100.0f * (float)item2.getHoningLimit(itemStack)));
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Honing progression set to \u00a7e" + progress + "%\u00a7r for ")).m_7220_(itemStack.m_41611_()), true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Item cannot be honed"));
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Main hand item is not a modular item"));
        }
        return 0;
    }

    private static int runRemoveModule(CommandContext<CommandSourceStack> context, String slot) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = TetraCommand.getItemStackOrReplacement((Player)player);
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            ItemModule module = item2.getModuleFromSlot(itemStack, slot);
            if (module != null) {
                String moduleIdentifiers = "'" + module.getKey() + "' (" + module.getVariantData((ItemStack)itemStack).key + ")";
                module.removeModule(itemStack);
                module.postRemove(itemStack, (Player)player);
                IModularItem.updateIdentifier(itemStack);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed module " + moduleIdentifiers + " from slot '" + slot + "' in item ")).m_7220_(itemStack.m_41611_()), true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"The provided slot is already empty"));
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Main hand item is not a modular item"));
        }
        return 0;
    }

    private static int runAddModule(CommandContext<CommandSourceStack> context, String slot, String moduleKey, String variantKey) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = TetraCommand.getItemStackOrReplacement((Player)player);
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            ItemModule module = ItemUpgradeRegistry.instance.getModule(moduleKey);
            if (module != null) {
                ItemModule previousModule = item2.getModuleFromSlot(itemStack, slot);
                if (previousModule != null) {
                    previousModule.removeModule(itemStack);
                    previousModule.postRemove(itemStack, (Player)player);
                }
                module.addModule(itemStack, variantKey, (Player)player);
                IModularItem.updateIdentifier(itemStack);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Added module " + moduleKey + " in slot '" + slot + "' in item ")).m_7220_(itemStack.m_41611_()), true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                return 1;
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Main hand item is not a modular item"));
        }
        return 0;
    }

    private static int runClearImprovements(CommandContext<CommandSourceStack> context, String slot) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = TetraCommand.getItemStackOrReplacement((Player)player);
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            ItemModule itemModule = item2.getModuleFromSlot(itemStack, slot);
            if (itemModule instanceof ItemModuleMajor) {
                ItemModuleMajor module = (ItemModuleMajor)itemModule;
                ImprovementData[] improvements = module.getImprovements(itemStack);
                Arrays.stream(improvements).forEach(improvement -> module.removeImprovement(itemStack, improvement.key));
                IModularItem.updateIdentifier(itemStack);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Cleared " + improvements.length + " improvements from slot '" + slot + "' in item ")).m_7220_(itemStack.m_41611_()), true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"The provided slot is empty (or not a major module slot)"));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Main hand item is not a modular item"));
            return 0;
        }
        return 1;
    }

    private static int runRemoveImprovement(CommandContext<CommandSourceStack> context, String slot, String improvementKey) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = TetraCommand.getItemStackOrReplacement((Player)player);
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            ItemModule itemModule = item2.getModuleFromSlot(itemStack, slot);
            if (itemModule instanceof ItemModuleMajor) {
                ItemModuleMajor module = (ItemModuleMajor)itemModule;
                module.removeImprovement(itemStack, improvementKey);
                IModularItem.updateIdentifier(itemStack);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed improvement '" + improvementKey + "' from slot '" + slot + "' in item ")).m_7220_(itemStack.m_41611_()), true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"The provided slot is empty (or not a major module slot)"));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Main hand item is not a modular item"));
            return 0;
        }
        return 1;
    }

    private static int runAddImprovement(CommandContext<CommandSourceStack> context, String slot, String improvementKey, int level) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = TetraCommand.getItemStackOrReplacement((Player)player);
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            ItemModule itemModule = item2.getModuleFromSlot(itemStack, slot);
            if (itemModule instanceof ItemModuleMajor) {
                ItemModuleMajor module = (ItemModuleMajor)itemModule;
                module.removeCollidingImprovements(itemStack, improvementKey, level);
                module.addImprovement(itemStack, improvementKey, level);
                IModularItem.updateIdentifier(itemStack);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Added improvement '" + improvementKey + "' at level " + level + " from slot '" + slot + "' in item ")).m_7220_(itemStack.m_41611_()), true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"The provided slot is empty (or not a major module slot)"));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Main hand item is not a modular item"));
            return 0;
        }
        return 1;
    }

    private static int runClearEnchantments(CommandContext<CommandSourceStack> context, String slot) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = TetraCommand.getItemStackOrReplacement((Player)player);
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            ItemModule itemModule = item2.getModuleFromSlot(itemStack, slot);
            if (itemModule instanceof ItemModuleMajor) {
                ItemModuleMajor module = (ItemModuleMajor)itemModule;
                Map<Enchantment, Integer> enchantments = module.getEnchantments(itemStack);
                module.removeEnchantments(itemStack);
                IModularItem.updateIdentifier(itemStack);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Cleared " + enchantments.size() + " enchantments from slot '" + slot + "' in item ")).m_7220_(itemStack.m_41611_()), true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"The provided slot is empty (or not a major module slot)"));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Main hand item is not a modular item"));
            return 0;
        }
        return 1;
    }

    private static int runRemoveEnchantment(CommandContext<CommandSourceStack> context, String slot, Holder<Enchantment> enchantment) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = TetraCommand.getItemStackOrReplacement((Player)player);
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            ItemModule itemModule = item2.getModuleFromSlot(itemStack, slot);
            if (itemModule instanceof ItemModuleMajor) {
                ItemModuleMajor module = (ItemModuleMajor)itemModule;
                String enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)((Enchantment)enchantment.get())).toString();
                TetraEnchantmentHelper.removeEnchantment(itemStack, enchantmentId);
                IModularItem.updateIdentifier(itemStack);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed enchantment '" + enchantmentId + "' from item ")).m_7220_(itemStack.m_41611_()), true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"The provided slot is empty (or not a major module slot)"));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Main hand item is not a modular item"));
            return 0;
        }
        return 1;
    }

    private static int runAddEnchantment(CommandContext<CommandSourceStack> context, String slot, Holder<Enchantment> enchantmentHolder, int level) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = TetraCommand.getItemStackOrReplacement((Player)player);
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            ItemModule itemModule = item2.getModuleFromSlot(itemStack, slot);
            if (itemModule instanceof ItemModuleMajor) {
                ItemModuleMajor module = (ItemModuleMajor)itemModule;
                Enchantment enchantment = (Enchantment)enchantmentHolder.get();
                String enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString();
                int currentLevel = itemStack.m_41720_().getEnchantmentLevel(itemStack, enchantment);
                TetraEnchantmentHelper.removeEnchantment(itemStack, enchantmentId);
                TetraEnchantmentHelper.applyEnchantment(itemStack, module.getSlot(), enchantment, level);
                IModularItem.updateIdentifier(itemStack);
                if (currentLevel > 0) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Updated enchantment '" + enchantmentId + "' to level " + level + " in slot '" + slot + "' in item ")).m_7220_(itemStack.m_41611_()), true);
                } else {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Added enchantment '" + enchantmentId + "' at level " + level + " for slot '" + slot + "' in item ")).m_7220_(itemStack.m_41611_()), true);
                }
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"The provided slot is empty (or not a major module slot)"));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Main hand item is not a modular item"));
            return 0;
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> getMajorSlotSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        ItemStack itemStack;
        Item item;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null && (item = (itemStack = TetraCommand.getItemStackOrReplacement((Player)player)).m_41720_()) instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            return SharedSuggestionProvider.m_82981_(Arrays.stream(item2.getMajorModuleKeys(itemStack)).map(key -> "\"" + key + "\""), (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> getAllSlotSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        ItemStack itemStack;
        Item item;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null && (item = (itemStack = TetraCommand.getItemStackOrReplacement((Player)player)).m_41720_()) instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            List<String> suggestions = Stream.concat(Arrays.stream(item2.getMajorModuleKeys(itemStack)), Arrays.stream(item2.getMinorModuleKeys(itemStack))).map(slot -> "\"" + slot + "\"").toList();
            return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> getModuleSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String slot = StringArgumentType.getString(context, (String)"slot");
        return SharedSuggestionProvider.m_82967_((String[])((String[])ItemUpgradeRegistry.instance.getAllModules().stream().filter(module -> slot == null || slot.equals(module.getSlot())).filter(module -> !module.perk).map(ItemModule::getKey).map(key -> "\"" + key + "\"").toArray(String[]::new)), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> getVariantSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        ItemModule module = ItemUpgradeRegistry.instance.getModule(StringArgumentType.getString(context, (String)"module"));
        return SharedSuggestionProvider.m_82981_(Arrays.stream(module.getVariantData()).map(data -> data.key).map(key -> "\"" + key + "\""), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> getAvailableImprovementSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        IModularItem item;
        ItemStack itemStack;
        Object object;
        String slot = StringArgumentType.getString(context, (String)"slot");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null && (object = (itemStack = TetraCommand.getItemStackOrReplacement((Player)player)).m_41720_()) instanceof IModularItem && (object = (item = (IModularItem)object).getModuleFromSlot(itemStack, slot)) instanceof ItemModuleMajor) {
            ItemModuleMajor module = (ItemModuleMajor)object;
            List<String> suggestions = Arrays.stream(module.improvements).map(improvement -> improvement.key).map(key -> "\"" + key + "\"").toList();
            return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> getCurrentImprovementSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        IModularItem item;
        ItemStack itemStack;
        Object object;
        String slot = StringArgumentType.getString(context, (String)"slot");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null && (object = (itemStack = TetraCommand.getItemStackOrReplacement((Player)player)).m_41720_()) instanceof IModularItem && (object = (item = (IModularItem)object).getModuleFromSlot(itemStack, slot)) instanceof ItemModuleMajor) {
            ItemModuleMajor module = (ItemModuleMajor)object;
            List<String> suggestions = Arrays.stream(module.getImprovements(itemStack)).map(improvement -> improvement.key).map(key -> "\"" + key + "\"").toList();
            return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> getImprovementLevelSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        IModularItem item;
        ItemStack itemStack;
        Object object;
        String slot = StringArgumentType.getString(context, (String)"slot");
        String improvementKey = StringArgumentType.getString(context, (String)"improvement");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null && (object = (itemStack = TetraCommand.getItemStackOrReplacement((Player)player)).m_41720_()) instanceof IModularItem && (object = (item = (IModularItem)object).getModuleFromSlot(itemStack, slot)) instanceof ItemModuleMajor) {
            ItemModuleMajor module = (ItemModuleMajor)object;
            List<String> suggestions = Arrays.stream(module.improvements).filter(improvement -> improvement.key.equals(improvementKey)).map(improvement -> improvement.level).map(String::valueOf).toList();
            return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> getCurrentEnchantmentsSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        IModularItem item;
        ItemStack itemStack;
        Object object;
        String slot = StringArgumentType.getString(context, (String)"slot");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null && (object = (itemStack = TetraCommand.getItemStackOrReplacement((Player)player)).m_41720_()) instanceof IModularItem && (object = (item = (IModularItem)object).getModuleFromSlot(itemStack, slot)) instanceof ItemModuleMajor) {
            ItemModuleMajor module = (ItemModuleMajor)object;
            List<String> suggestions = module.getEnchantments(itemStack).keySet().stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getKey(arg_0)).filter(Objects::nonNull).map(ResourceLocation::toString).toList();
            return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> getEnchantmentLevelSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        Holder.Reference enchantment = ResourceArgument.m_245369_(context, (String)"enchantment");
        List<String> suggestions = IntStream.rangeClosed(((Enchantment)enchantment.get()).m_44702_(), ((Enchantment)enchantment.get()).m_6586_()).mapToObj(String::valueOf).toList();
        return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
    }

    private static ItemStack getItemStackOrReplacement(Player player) {
        ItemStack replacement;
        ItemStack itemStack = player.m_21205_();
        if (!(itemStack.m_41720_() instanceof IModularItem) && !(replacement = ItemUpgradeRegistry.instance.getReplacement(itemStack)).m_41619_()) {
            return replacement;
        }
        return itemStack;
    }
}

