/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.levelgen;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlockEntity;

@ParametersAreNonnullByDefault
public class ForgedContainerProcessor
extends StructureProcessor {
    public static final ForgedContainerProcessor INSTANCE = new ForgedContainerProcessor();
    public static final Codec<ForgedContainerProcessor> codec = Codec.unit(() -> INSTANCE);
    public static RegistryObject<StructureProcessorType<?>> type;

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo $, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        if (blockInfo.f_74676_().m_60734_() instanceof ForgedContainerBlock) {
            RandomSource random = (Boolean)blockInfo.f_74676_().m_61143_((Property)ForgedContainerBlock.flippedProp) != false ? placementSettings.m_230326_(blockInfo.f_74675_().m_121945_(((Direction)blockInfo.f_74676_().m_61143_((Property)ForgedContainerBlock.facingProp)).m_122428_())) : placementSettings.m_230326_(blockInfo.f_74675_());
            CompoundTag newCompound = blockInfo.f_74677_().m_6426_();
            int[] lockIntegrity = new int[ForgedContainerBlockEntity.lockCount];
            for (int i = 0; i < lockIntegrity.length; ++i) {
                lockIntegrity[i] = 1 + random.m_188503_(ForgedContainerBlockEntity.lockIntegrityMax - 1);
            }
            ForgedContainerBlockEntity.writeLockData(newCompound, lockIntegrity);
            int lidIntegrity = 1 + random.m_188503_(ForgedContainerBlockEntity.lidIntegrityMax - 1);
            ForgedContainerBlockEntity.writeLidData(newCompound, lidIntegrity);
            BlockState newState = ForgedContainerBlockEntity.getUpdatedBlockState(blockInfo.f_74676_(), lockIntegrity, lidIntegrity);
            return new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), newState, newCompound);
        }
        return blockInfo;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)type.get();
    }
}

