/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.inventory;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.SlotType;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltInventory;

@ParametersAreNonnullByDefault
public class QuickslotInventory
extends ToolbeltInventory {
    public static final int maxSize = 12;
    private static final String inventoryKey = "quickInventory";
    private static final String shadowsKey = "quickShadows";
    private final NonNullList<ItemStack> inventoryShadows;

    public QuickslotInventory(ItemStack stack) {
        super(inventoryKey, stack, 12, SlotType.quick);
        ModularToolbeltItem item = (ModularToolbeltItem)stack.m_41720_();
        this.numSlots = item.getNumSlots(stack, SlotType.quick);
        this.inventoryShadows = NonNullList.m_122780_((int)12, (Object)ItemStack.f_41583_);
        this.predicate = QuickslotInventory.getPredicate("quickslot");
        this.readFromNBT(stack.m_41784_());
    }

    @Override
    public void readFromNBT(CompoundTag tagCompound) {
        super.readFromNBT(tagCompound);
        ListTag shadows = tagCompound.m_128437_(shadowsKey, 10);
        for (int i = 0; i < shadows.size(); ++i) {
            CompoundTag item = shadows.m_128728_(i);
            int slot = item.m_128451_("slot");
            if (0 > slot || slot >= this.m_6643_()) continue;
            this.inventoryShadows.set(slot, (Object)ItemStack.m_41712_((CompoundTag)item));
        }
    }

    @Override
    public void writeToNBT(CompoundTag tagcompound) {
        super.writeToNBT(tagcompound);
        ListTag shadows = new ListTag();
        for (int i = 0; i < 12; ++i) {
            CompoundTag item = new CompoundTag();
            item.m_128405_("slot", i);
            this.getShadowOfSlot(i).m_41739_(item);
            shadows.add((Object)item);
        }
        tagcompound.m_128365_(shadowsKey, (Tag)shadows);
    }

    public ItemStack getShadowOfSlot(int index) {
        return (ItemStack)this.inventoryShadows.get(index);
    }

    @Override
    public void m_6596_() {
        int i;
        for (i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41613_() != 0) continue;
            this.inventoryContents.set(i, (Object)ItemStack.f_41583_);
        }
        for (i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            this.inventoryShadows.set(i, (Object)this.m_8020_(i).m_41777_());
        }
        this.writeToNBT(this.toolbeltItemStack.m_41784_());
    }

    private int getShadowIndex(ItemStack itemStack) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (!itemStack.m_150930_(this.getShadowOfSlot(i).m_41720_()) || !this.m_8020_(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean storeItemInInventory(ItemStack itemStack) {
        if (!this.isItemValid(itemStack)) {
            return false;
        }
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack storedStack = this.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)storedStack) || storedStack.m_41613_() >= storedStack.m_41741_()) continue;
            int moveCount = Math.min(itemStack.m_41613_(), storedStack.m_41741_() - storedStack.m_41613_());
            storedStack.m_41769_(moveCount);
            this.m_6836_(i, storedStack);
            itemStack.m_41774_(moveCount);
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        int restockIndex = this.getShadowIndex(itemStack);
        if (restockIndex != -1) {
            this.m_6836_(restockIndex, itemStack);
            return true;
        }
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            this.m_6836_(i, itemStack);
            return true;
        }
        return false;
    }
}

