/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.AnimationChain;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.VerticalTabButtonGui;

@ParametersAreNonnullByDefault
public class VerticalTabIconButtonGui
extends VerticalTabButtonGui {
    private final GuiTexture icon;
    private final AnimationChain iconFlash;

    public VerticalTabIconButtonGui(int x, int y, ResourceLocation texture, int textureX, int textureY, String label, String keybinding, Runnable onClickHandler, boolean initiallyActive) {
        super(x, y, label, keybinding, onClickHandler, initiallyActive);
        this.icon = new GuiTexture(-3, 3, 10, 9, textureX, textureY, texture);
        this.icon.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.icon);
        this.iconFlash = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(40, (GuiElement)this.icon).applyTo(new Applier[]{new Applier.TranslateX(-4.0f)}), new KeyframeAnimation(60, (GuiElement)this.icon).applyTo(new Applier[]{new Applier.TranslateX(-3.0f)})});
        this.label.setX(-16);
        this.labelShow = new KeyframeAnimation(100, (GuiElement)this.label).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(-16.0f)});
        this.labelHide = new KeyframeAnimation(150, (GuiElement)this.label).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(-13.0f)});
        this.width = this.label.getWidth() + 20;
        this.updateStyling();
    }

    @Override
    protected void updateStyling() {
        super.updateStyling();
        if (this.icon != null) {
            if (this.isActive) {
                this.icon.setColor(this.hasFocus() ? 0xFFFFCC : 0xFFFFFF);
            } else if (this.hasContent) {
                this.icon.setColor(this.hasFocus() ? 0x8F8F6F : 0x7F7F7F);
            } else {
                this.icon.setColor(this.hasFocus() ? 0x8F8F6F : 0x7F7F7F);
            }
        }
    }

    @Override
    public void setActive(boolean isActive) {
        super.setActive(isActive);
        if (isActive) {
            this.iconFlash.stop();
            this.iconFlash.start();
        }
    }
}

