/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.util.ToolActionHelper;

@ParametersAreNonnullByDefault
public class UnboundExtractionEffect {
    public static void breakBlocks(ItemModularHandheld item, ItemStack itemStack, int effectLevel, ServerLevel world, BlockState state, BlockPos pos, LivingEntity entity) {
        Player player = CastOptional.cast((Object)entity, Player.class).orElse(null);
        if (player != null && effectLevel > 0) {
            Vec3 entityPosition = entity.m_20299_(0.0f);
            double lookDistance = Optional.ofNullable(entity.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get())).map(AttributeInstance::m_22135_).orElse(5.0);
            Vec3 lookingPosition = entity.m_20154_().m_82490_(lookDistance).m_82549_(entityPosition);
            BlockHitResult rayTrace = world.m_45547_(new ClipContext(entityPosition, lookingPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
            Direction direction = rayTrace.m_6662_() == HitResult.Type.BLOCK ? rayTrace.m_82434_().m_122424_() : Direction.m_122382_((Entity)entity)[0];
            float referenceHardness = state.m_60800_((BlockGetter)world, pos);
            ToolAction referenceTool = ToolActionHelper.getAppropriateTools(state).stream().filter(tool -> item.canPerformAction(itemStack, (ToolAction)tool)).findFirst().orElse(null);
            if (referenceTool != null && item.getToolLevel(itemStack, referenceTool) > 0) {
                double critMultiplier = CritEffect.rollMultiplier(entity.m_217043_(), item, itemStack);
                if (critMultiplier != 1.0) {
                    effectLevel = (int)((double)effectLevel * critMultiplier);
                    world.m_8767_((ParticleOptions)ParticleTypes.f_123808_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 15, 0.2, 0.2, 0.2, 0.0);
                }
                Vec3i limiter = UnboundExtractionEffect.getLimiter(item, direction, player.m_6350_(), itemStack);
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>(UnboundExtractionEffect.getRegularOffsets(pos, pos, limiter));
                LinkedList<BlockPos> backupPositions = new LinkedList<BlockPos>(UnboundExtractionEffect.getBackupOffsets(pos, pos, limiter));
                int blockCount = effectLevel;
                ServerScheduler.schedule(player.m_217043_().m_188503_(3), () -> UnboundExtractionEffect.breakRecursive((Level)world, player, item, itemStack, direction, pos, limiter, positions, backupPositions, referenceHardness, referenceTool, blockCount));
                item.applyDamage(effectLevel, itemStack, entity);
                item.tickProgression(entity, itemStack, Mth.m_14165_((double)((double)effectLevel / 2.0)));
            }
        }
    }

    private static void breakRecursive(Level world, Player player, ItemModularHandheld item, ItemStack itemStack, Direction direction, BlockPos origin, Vec3i limiter, List<BlockPos> positions, List<BlockPos> backupPositions, float refHardness, ToolAction refTool, float remaining) {
        while (positions.size() > 0 || backupPositions.size() > 0) {
            BlockPos target = positions.size() > 0 ? positions.remove(player.m_217043_().m_188503_(positions.size())) : backupPositions.remove(player.m_217043_().m_188503_(backupPositions.size()));
            if (!UnboundExtractionEffect.breakBlock(world, player, item, itemStack, target, refHardness, refTool)) continue;
            if (remaining > 0.0f) {
                positions.addAll(UnboundExtractionEffect.getRegularOffsets(target, origin, limiter));
                backupPositions.addAll(UnboundExtractionEffect.getBackupOffsets(target, origin, limiter));
                ServerScheduler.schedule(player.m_217043_().m_188503_(3), () -> UnboundExtractionEffect.breakRecursive(world, player, item, itemStack, direction, origin, limiter, positions, backupPositions, refHardness, refTool, remaining - 1.0f));
            }
            return;
        }
    }

    private static Vec3i getLimiter(ModularItem item, Direction direction, Direction horizontalDirection, ItemStack itemStack) {
        Vec3i lateralVec;
        Vec3i medialVec;
        Vec3i axialVec;
        int lateralLimit = item.getEffectLevel(itemStack, ItemEffect.extractionLateralLimit);
        int medialLimit = item.getEffectLevel(itemStack, ItemEffect.extractionMedialLimit);
        int axialLimit = item.getEffectLevel(itemStack, ItemEffect.extractionAxialLimit);
        if (direction.m_122434_() == Direction.Axis.Y) {
            axialVec = new Vec3i(0, 1, 0);
            medialVec = new Vec3i(Math.abs(horizontalDirection.m_122429_()), 0, Math.abs(horizontalDirection.m_122431_()));
            lateralVec = new Vec3i(medialVec.m_123343_(), 0, medialVec.m_123341_());
        } else {
            axialVec = new Vec3i(Math.abs(direction.m_122429_()), 0, Math.abs(direction.m_122431_()));
            medialVec = new Vec3i(0, 1, 0);
            lateralVec = new Vec3i(axialVec.m_123343_(), 0, axialVec.m_123341_());
        }
        Vec3i result = new Vec3i(axialVec.m_123341_() * axialLimit + medialLimit * medialVec.m_123341_() + lateralVec.m_123341_() * lateralLimit, axialVec.m_123342_() * axialLimit + medialLimit * medialVec.m_123342_() + lateralVec.m_123342_() * lateralLimit, axialVec.m_123343_() * axialLimit + medialLimit * medialVec.m_123343_() + lateralVec.m_123343_() * lateralLimit);
        return new Vec3i(result.m_123341_() > 0 ? result.m_123341_() : Integer.MIN_VALUE, result.m_123342_() > 0 ? result.m_123342_() : Integer.MIN_VALUE, result.m_123343_() > 0 ? result.m_123343_() : Integer.MIN_VALUE);
    }

    private static boolean isPossible(BlockPos target, BlockPos origin, Vec3i limiter) {
        return UnboundExtractionEffect.isPossible(target.m_123341_(), origin.m_123341_(), limiter.m_123341_()) && UnboundExtractionEffect.isPossible(target.m_123342_(), origin.m_123342_(), limiter.m_123342_()) && UnboundExtractionEffect.isPossible(target.m_123343_(), origin.m_123343_(), limiter.m_123343_());
    }

    private static boolean isPossible(int target, int origin, int limiter) {
        if (limiter == Integer.MIN_VALUE) {
            return true;
        }
        return Math.abs(target - origin) < limiter;
    }

    private static void breakInner(Level world, Player player, ItemModularHandheld item, ItemStack itemStack, Direction direction, BlockPos pos, float refHardness, ToolAction refTool) {
        Vec3i axis1 = RotationHelper.shiftAxis((Vec3i)direction.m_122436_());
        Vec3i axis2 = RotationHelper.shiftAxis((Vec3i)axis1);
        UnboundExtractionEffect.breakBlock(world, player, item, itemStack, pos.m_121955_(axis1), refHardness, refTool);
        UnboundExtractionEffect.breakBlock(world, player, item, itemStack, pos.m_121996_(axis1), refHardness, refTool);
        UnboundExtractionEffect.breakBlock(world, player, item, itemStack, pos.m_121955_(axis2), refHardness, refTool);
        UnboundExtractionEffect.breakBlock(world, player, item, itemStack, pos.m_121996_(axis2), refHardness, refTool);
    }

    private static void breakOuter(Level world, Player player, ItemModularHandheld item, ItemStack itemStack, Direction direction, BlockPos pos, float refHardness, ToolAction refTool) {
        Vec3i axis1 = RotationHelper.shiftAxis((Vec3i)direction.m_122436_());
        Vec3i axis2 = RotationHelper.shiftAxis((Vec3i)axis1);
        UnboundExtractionEffect.breakBlock(world, player, item, itemStack, pos.m_121955_(axis1).m_121955_(axis2), refHardness, refTool);
        UnboundExtractionEffect.breakBlock(world, player, item, itemStack, pos.m_121996_(axis1).m_121996_(axis2), refHardness, refTool);
        UnboundExtractionEffect.breakBlock(world, player, item, itemStack, pos.m_121955_(axis1).m_121996_(axis2), refHardness, refTool);
        UnboundExtractionEffect.breakBlock(world, player, item, itemStack, pos.m_121996_(axis1).m_121955_(axis2), refHardness, refTool);
    }

    private static boolean breakBlock(Level world, Player player, ItemModularHandheld item, ItemStack itemStack, BlockPos pos, float refHardness, ToolAction refTool) {
        BlockState offsetState = world.m_8055_(pos);
        float blockHardness = offsetState.m_60800_((BlockGetter)world, pos);
        if (ToolActionHelper.playerCanDestroyBlock(player, offsetState, pos, itemStack) && blockHardness != -1.0f && blockHardness <= refHardness && ToolActionHelper.isEffectiveOn(refTool, offsetState) && EffectHelper.breakBlock(world, player, itemStack, pos, offsetState, true, false)) {
            EffectHelper.sendEventToPlayer((ServerPlayer)player, 2001, pos, Block.m_49956_((BlockState)offsetState));
            item.applyBlockBreakEffects(itemStack, world, offsetState, pos, (LivingEntity)player);
            return true;
        }
        return false;
    }

    private static Collection<BlockPos> getRegularOffsets(BlockPos pos, BlockPos origin, Vec3i limiter) {
        return ImmutableList.of((Object)pos.m_7494_(), (Object)pos.m_7495_(), (Object)pos.m_122012_(), (Object)pos.m_122024_(), (Object)pos.m_122019_(), (Object)pos.m_122029_()).stream().filter(posInner -> UnboundExtractionEffect.isPossible(posInner, origin, limiter)).toList();
    }

    private static Collection<BlockPos> getBackupOffsets(BlockPos pos, BlockPos origin, Vec3i limiter) {
        return ImmutableList.of((Object)pos.m_7494_().m_122024_().m_122019_(), (Object)pos.m_7494_().m_122024_().m_122012_(), (Object)pos.m_7494_().m_122029_().m_122019_(), (Object)pos.m_7494_().m_122029_().m_122012_(), (Object)pos.m_7494_().m_122024_(), (Object)pos.m_7494_().m_122012_(), (Object)pos.m_7494_().m_122029_(), (Object)pos.m_7494_().m_122019_(), (Object)pos.m_122024_().m_122019_(), (Object)pos.m_122024_().m_122012_(), (Object)pos.m_122029_().m_122019_(), (Object)pos.m_122029_().m_122012_(), (Object[])new BlockPos[]{pos.m_7495_().m_122024_().m_122019_(), pos.m_7495_().m_122024_().m_122012_(), pos.m_7495_().m_122029_().m_122019_(), pos.m_7495_().m_122029_().m_122012_(), pos.m_7495_().m_122024_(), pos.m_7495_().m_122012_(), pos.m_7495_().m_122029_(), pos.m_7495_().m_122019_()}).stream().filter(posInner -> UnboundExtractionEffect.isPossible(posInner, origin, limiter)).toList();
    }
}

