/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class SlamEffect
extends ChargedAbilityEffect {
    public static final SlamEffect instance = new SlamEffect();

    SlamEffect() {
        super(10, 1.0, 40, 6.0, ItemEffect.slam, ChargedAbilityEffect.TargetRequirement.either, UseAnim.SPEAR, "raised");
    }

    private static void groundSlamEntity(Player attacker, LivingEntity target, ItemModularHandheld item, ItemStack itemStack, Vec3 origin, double damageMultiplier, int slowDuration, double momentumEfficiency, int revengeLevel) {
        ServerScheduler.schedule(target.m_20183_().m_123333_((Vec3i)BlockPos.m_274446_((Position)origin)) - 3, () -> {
            float knockback = momentumEfficiency > 0.0 ? 0.1f : 0.5f;
            AbilityUseResult result = item.hitEntity(itemStack, attacker, target, damageMultiplier, knockback, knockback);
            if (momentumEfficiency > 0.0) {
                target.m_20193_().m_5594_(null, target.m_20183_(), SoundEvents.f_11908_, SoundSource.PLAYERS, 1.0f, 0.7f);
            } else {
                target.m_20193_().m_5594_(null, target.m_20183_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 0.9f);
            }
            if (result != AbilityUseResult.fail) {
                if (slowDuration > 0) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slowDuration, 1, false, true));
                }
                if (momentumEfficiency > 0.0) {
                    double velocity = momentumEfficiency;
                    target.m_5997_(0.0, velocity *= 1.0 - target.m_21133_(Attributes.f_22278_), 0.0);
                    target.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, 40, 0, false, false));
                }
                if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
                    target.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, revengeLevel, 0, false, false));
                    RevengeTracker.removeEnemySynced((ServerPlayer)attacker, (Entity)target);
                }
            }
            if (result == AbilityUseResult.crit) {
                RandomSource rand = target.m_217043_();
                CastOptional.cast((Object)target.m_9236_(), ServerLevel.class).ifPresent(world -> world.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_(), target.m_20186_(), target.m_20189_(), 10, rand.m_188583_() * 0.3, rand.m_188583_() * 0.5, rand.m_188583_() * 0.3, (double)0.1f));
            }
        });
    }

    @Override
    public int getChargeTime(Player attacker, ItemModularHandheld item, ItemStack itemStack) {
        if (ComboPoints.canSpend(item, itemStack)) {
            return (int)((double)super.getChargeTime(attacker, item, itemStack) * (1.0 - (double)item.getEffectLevel(itemStack, ItemEffect.abilityCombo) / 100.0 * (double)ComboPoints.get((Entity)attacker)));
        }
        return super.getChargeTime(attacker, item, itemStack);
    }

    @Override
    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        AbilityUseResult result = this.directSlam(attacker, hand, item, itemStack, target, hitVec, chargedTicks);
        double overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend);
        attacker.m_36399_(overextendLevel > 0.0 ? 6.0f : 1.0f);
        attacker.m_21011_(hand, false);
        attacker.m_36335_().m_41524_((Item)item, Math.round((float)this.getCooldown(item, itemStack) * 1.5f));
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        if (revengeLevel > 0) {
            RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
        }
        item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
        int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
        if (echoLevel > 0) {
            this.echoTarget(attacker, hand, item, itemStack, target, hitVec, chargedTicks);
        }
    }

    public AbilityUseResult directSlam(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        AbilityUseResult result;
        double overextendLevel;
        double momentumEfficiency;
        int momentumLevel;
        int stunDuration = 0;
        double damageMultiplier = (double)item.getEffectLevel(itemStack, ItemEffect.slam) * 1.5 / 100.0;
        float knockbackBase = item.getEffectEfficiency(itemStack, ItemEffect.slam);
        float knockbackMultiplier = 1.0f;
        boolean isDefensive = this.isDefensive(item, itemStack, hand);
        int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        if (isDefensive) {
            damageMultiplier -= 0.3;
            stunDuration = item.getEffectLevel(itemStack, ItemEffect.abilityDefensive);
        }
        if (overchargeBonus > 0) {
            double bonus = (double)(overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
            damageMultiplier += bonus;
            knockbackMultiplier = (float)((double)knockbackMultiplier + bonus);
        }
        if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0) {
            stunDuration = momentumLevel;
        }
        if ((momentumEfficiency = (double)item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum)) > 0.0) {
            knockbackMultiplier = 0.4f;
        }
        if ((overextendLevel = (double)item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0.0 && !attacker.m_36324_().m_38721_()) {
            damageMultiplier += overextendLevel / 100.0;
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, knockbackMultiplier * knockbackBase, knockbackMultiplier / 2.0f)) != AbilityUseResult.fail) {
            double exhilarationEfficiency;
            if (stunDuration > 0) {
                target.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, stunDuration, 0, false, false));
            }
            if (momentumEfficiency > 0.0) {
                double velocity = momentumEfficiency;
                target.m_5997_(0.0, velocity *= 1.0 - target.m_21133_(Attributes.f_22278_), 0.0);
            }
            if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
                target.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, revengeLevel, 0, false, false));
            }
            if ((exhilarationEfficiency = (double)item.getEffectEfficiency(itemStack, ItemEffect.abilityExhilaration)) > 0.0) {
                this.knockbackExhilaration(attacker, attacker.m_20182_(), target, target.m_9236_().m_46467_() + 200L, exhilarationEfficiency);
            }
            RandomSource rand = target.m_217043_();
            CastOptional.cast((Object)target.m_9236_(), ServerLevel.class).ifPresent(world -> world.m_8767_((ParticleOptions)ParticleTypes.f_123797_, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, 10, rand.m_188583_() * 0.3, rand.m_188583_() * (double)target.m_20206_() * 0.8, rand.m_188583_() * 0.3, (double)0.1f));
            target.m_20193_().m_5594_(attacker, target.m_20183_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 0.7f);
        } else {
            target.m_20193_().m_5594_(attacker, target.m_20183_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 0.7f);
        }
        return result;
    }

    private void knockbackExhilaration(Player attacker, Vec3 origin, LivingEntity target, long timeLimit, double multiplier) {
        ServerScheduler.schedule(20, () -> {
            if (target.m_20096_()) {
                double distance = Math.min(20.0, origin.m_82554_(target.m_20182_()));
                int amplifier = (int)(distance * multiplier) - 1;
                if (amplifier >= 0) {
                    attacker.m_7292_(new MobEffectInstance((MobEffect)SmallStrengthPotionEffect.instance, 200, amplifier, false, true));
                }
            } else if (target.m_9236_().m_46467_() < timeLimit) {
                this.knockbackExhilaration(attacker, origin, target, timeLimit, multiplier);
            }
        });
    }

    @Override
    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, BlockPos targetPos, Vec3 hitVec, int chargedTicks) {
        if (!attacker.m_9236_().f_46443_) {
            int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
            int slowDuration = this.isDefensive(item, itemStack, hand) ? (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) * 20.0f) : 0;
            double momentumEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum);
            int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
            double overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend);
            double range = this.getAoeRange(attacker, item, itemStack, overchargeBonus);
            Vec3 direction = hitVec.m_82546_(attacker.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
            double yaw = Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_);
            AABB boundingBox = new AABB(hitVec, hitVec).m_82377_(range + 1.0, 4.0, range + 1.0).m_82383_(direction.m_82490_(range / 2.0));
            List<LivingEntity> targets = attacker.m_9236_().m_45976_(LivingEntity.class, boundingBox).stream().filter(Entity::m_6084_).filter(Entity::m_6097_).filter(entity -> !attacker.equals(entity)).filter(entity -> this.inRange(hitVec, (Entity)entity, yaw, range)).collect(Collectors.toList());
            double damageMultiplier = this.getAoeDamageMultiplier(attacker, item, itemStack, slowDuration > 0, overchargeBonus, targets);
            targets.forEach(entity -> SlamEffect.groundSlamEntity(attacker, entity, item, itemStack, hitVec, damageMultiplier, slowDuration, momentumEfficiency, revengeLevel));
            this.spawnGroundParticles(attacker.m_9236_(), hitVec, direction, yaw, range);
            attacker.m_36399_(overextendLevel > 0.0 ? 6.0f : 1.0f);
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                this.echoGround(attacker, item, itemStack, hitVec, direction, yaw, range, damageMultiplier * (double)echoLevel / 100.0, slowDuration, momentumEfficiency, revengeLevel);
            }
        }
        attacker.m_21011_(hand, false);
        attacker.m_36335_().m_41524_((Item)item, this.getCooldown(item, itemStack));
        item.tickProgression((LivingEntity)attacker, itemStack, 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private void echoGround(Player attacker, ItemModularHandheld item, ItemStack itemStack, Vec3 hitVec, Vec3 direction, double yaw, double range, double damageMultiplier, int slowDuration, double momentumEfficiency, int revengeLevel) {
        EchoHelper.echo(attacker, 60, () -> {
            AABB boundingBox = new AABB(hitVec, hitVec).m_82377_(range + 1.0, 4.0, range + 1.0).m_82383_(direction.m_82490_(range / 2.0));
            List<LivingEntity> targets = attacker.m_9236_().m_45976_(LivingEntity.class, boundingBox).stream().filter(Entity::m_6084_).filter(Entity::m_6097_).filter(entity -> this.inRange(hitVec, (Entity)entity, yaw, range)).collect(Collectors.toList());
            targets.forEach(entity -> SlamEffect.groundSlamEntity(attacker, entity, item, itemStack, hitVec, damageMultiplier, slowDuration, momentumEfficiency, revengeLevel));
            this.spawnGroundParticles(attacker.m_9236_(), hitVec, direction, yaw, range);
        });
    }

    private void echoTarget(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        if (!attacker.m_9236_().f_46443_) {
            EchoHelper.echo(attacker, 60, () -> {
                this.directSlam(attacker, hand, item, itemStack, target, hitVec, chargedTicks);
                int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
                if (revengeLevel > 0) {
                    RevengeTracker.removeEnemySynced((ServerPlayer)attacker, (Entity)target);
                }
            });
        }
    }

    private double getAoeDamageMultiplier(Player attacker, ItemModularHandheld item, ItemStack itemStack, boolean isDefensive, int overchargeBonus, List<LivingEntity> targets) {
        int exhilarationLevel;
        double overextendLevel;
        double damageMultiplier = (float)item.getEffectLevel(itemStack, ItemEffect.slam) / 100.0f;
        if (isDefensive) {
            damageMultiplier -= 0.3;
        }
        if (overchargeBonus > 0) {
            damageMultiplier += (double)(overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
        }
        if ((overextendLevel = (double)item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0.0 && !attacker.m_36324_().m_38721_()) {
            damageMultiplier += overextendLevel / 100.0;
        }
        if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0) {
            damageMultiplier += (double)(targets.size() * exhilarationLevel) / 100.0;
        }
        return damageMultiplier;
    }

    private double getAoeRange(Player attacker, ItemModularHandheld item, ItemStack itemStack, int overchargeBonus) {
        double overextendEfficiency;
        double range = 8.0;
        if (overchargeBonus > 0) {
            range += (double)((float)overchargeBonus * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge));
        }
        if ((overextendEfficiency = (double)item.getEffectEfficiency(itemStack, ItemEffect.abilityOverextend)) > 0.0 && !attacker.m_36324_().m_38721_()) {
            range += overextendEfficiency;
        }
        return range;
    }

    private void spawnGroundParticles(Level world, Vec3 origin, Vec3 direction, double yaw, double range) {
        RandomSource rand = world.m_213780_();
        BlockState originState = world.m_8055_(BlockPos.m_274446_((Position)origin));
        ((ServerLevel)world).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, originState), origin.m_7096_(), origin.m_7098_(), origin.m_7094_(), 8, 0.0, rand.m_188583_() * 0.1, 0.0, 0.1);
        world.m_5594_(null, BlockPos.m_274446_((Position)origin), originState.m_60827_().m_56775_(), SoundSource.PLAYERS, 1.5f, 0.5f);
        int bound = (int)Math.ceil(range / 2.0);
        BlockPos center = BlockPos.m_274446_((Position)origin.m_82549_(direction.m_82490_(range / 2.0)));
        origin = origin.m_82549_(direction.m_82490_(-1.0));
        BlockPos.MutableBlockPos targetPos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = -bound; x <= bound; ++x) {
            block1: for (int z = -bound; z <= bound; ++z) {
                targetPos.m_122154_((Vec3i)center, x, 0, z);
                if (!this.compareAngle(origin, targetPos, yaw)) continue;
                for (int y = -2; y < 2; ++y) {
                    targetPos.m_122154_((Vec3i)center, x, y, z);
                    BlockState targetState = world.m_8055_((BlockPos)targetPos);
                    if (!targetState.m_60815_() || world.m_8055_(targetPos.m_7494_()).m_60815_()) continue;
                    targetPos.m_7495_();
                    double distance = targetPos.m_203198_(origin.f_82479_, origin.f_82480_, origin.f_82481_);
                    if (!(distance < range * range)) continue block1;
                    double yOffset = targetState.m_60808_((BlockGetter)world, (BlockPos)targetPos).m_83215_().f_82292_;
                    BlockPos particlePos = targetPos.m_7949_();
                    ServerScheduler.schedule(particlePos.m_123333_((Vec3i)BlockPos.m_274446_((Position)origin)) - 3, () -> {
                        ((ServerLevel)world).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, targetState), (double)particlePos.m_123341_() + 0.5, (double)particlePos.m_123342_() + yOffset, (double)particlePos.m_123343_() + 0.5, 3, 0.0, rand.m_188583_() * 0.1, 0.0, 0.1);
                        if (rand.m_188501_() < 0.3f) {
                            world.m_5594_(null, particlePos, targetState.m_60827_().m_56779_(), SoundSource.PLAYERS, 1.0f, 0.5f);
                        }
                    });
                    continue block1;
                }
            }
        }
    }

    private boolean inRange(Vec3 origin, Entity entity, double originYaw, double range) {
        if (origin.m_82509_((Position)entity.m_20182_(), range)) {
            Vec3 direction = entity.m_20182_().m_82546_(origin);
            double entityYaw = Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_);
            double yawDiff = Math.abs((originYaw - entityYaw + Math.PI * 3) % (Math.PI * 2) - Math.PI);
            return yawDiff < 0.5235987755982988;
        }
        return false;
    }

    private boolean compareAngle(Vec3 originPos, BlockPos.MutableBlockPos offsetPos, double originYaw) {
        Vec3 direction = Vec3.m_82539_((Vec3i)offsetPos).m_82546_(originPos);
        double offsetYaw = Mth.m_14136_((double)direction.m_7096_(), (double)direction.m_7094_());
        double yawDiff = Math.abs((originYaw - offsetYaw + Math.PI * 3) % (Math.PI * 2) - Math.PI);
        return yawDiff < 0.5235987755982988;
    }
}

