/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import se.mickelus.tetra.blocks.ArcaneFireBlock;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.util.StreamHelper;

public class CombustingEffect {
    public static void perform(LivingEntity entity, ItemStack itemStack, double multiplier) {
        int effectLevel;
        if (!entity.m_9236_().f_46443_ && (effectLevel = (int)Math.round((double)EffectHelper.getEffectLevel(itemStack, ItemEffect.combusting) * multiplier)) > 0 && entity.m_217043_().m_188501_() < EffectHelper.getEffectEfficiency(itemStack, ItemEffect.combusting) / 100.0f) {
            boolean regularSuccess = CombustingEffect.igniteBlocksAround(entity.m_9236_(), entity.m_20183_(), 4, Mth.m_14143_((float)((float)effectLevel / 2.0f)), true, false);
            boolean arcaneSuccess = CombustingEffect.setBlocksAround(entity.m_9236_(), entity.m_20183_(), 4, Mth.m_14167_((float)((float)effectLevel / 2.0f)), true, ((ArcaneFireBlock)((Object)ArcaneFireBlock.instance.get())).m_49966_());
            if (regularSuccess || arcaneSuccess) {
                Vec3 pos = entity.m_20183_().m_252807_();
                ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 2, 0.0, 0.0, 0.0, (double)0.06f);
                ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 2, 0.0, 0.0, 0.0, 0.0);
                entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 0.6f, 1.2f);
            }
        }
    }

    public static boolean igniteBlocksAround(Level level, BlockPos origin, int radius, int count, boolean skipCenter, boolean soulfire) {
        return CombustingEffect.setBlocksAround(level, origin, radius, count, skipCenter, soulfire ? Blocks.f_50084_.m_49966_() : Blocks.f_50083_.m_49966_());
    }

    public static boolean setBlocksAround(Level level, BlockPos origin, int radius, int count, boolean skipCenter, BlockState blockState) {
        AtomicBoolean success = new AtomicBoolean(false);
        BlockPos.m_121985_((BlockPos)origin, (int)radius, (int)radius, (int)radius).map(BlockPos::new).filter(blockPos -> !origin.equals(blockPos) || !skipCenter).collect(StreamHelper.toShuffledList()).stream().filter(arg_0 -> ((Level)level).m_46859_(arg_0)).filter(blockPos -> blockState.m_60710_((LevelReader)level, blockPos)).limit(count).forEach(blockPos -> {
            if (level.m_7731_(blockPos, blockState, 3)) {
                success.set(true);
            }
        });
        return success.get();
    }

    private static boolean canSoulfireSpawn(Level level, BlockPos pos) {
        BlockPos belowPos = pos.m_7949_().m_7495_();
        return Block.m_49916_((VoxelShape)level.m_8055_(belowPos).m_60812_((BlockGetter)level, belowPos));
    }
}

