/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import se.mickelus.mutil.network.BlockPosPacket;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;

@ParametersAreNonnullByDefault
public class WorkbenchPacketTweak
extends BlockPosPacket {
    String slot;
    Map<String, Integer> tweaks;

    public WorkbenchPacketTweak() {
        this.tweaks = new HashMap<String, Integer>();
    }

    public WorkbenchPacketTweak(BlockPos pos, String slot, Map<String, Integer> tweaks) {
        super(pos);
        this.slot = slot;
        this.tweaks = tweaks;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        try {
            WorkbenchPacketTweak.writeString((String)this.slot, (FriendlyByteBuf)buffer);
        }
        catch (IOException e) {
            System.err.println("An error occurred when writing tweak packet to buffer");
        }
        buffer.writeInt(this.tweaks.size());
        this.tweaks.forEach((tweakKey, step) -> {
            try {
                WorkbenchPacketTweak.writeString((String)tweakKey, (FriendlyByteBuf)buffer);
                buffer.writeInt(step.intValue());
            }
            catch (IOException e) {
                System.err.println("An error occurred when writing tweak packet to buffer");
            }
        });
    }

    public void fromBytes(FriendlyByteBuf buffer) {
        super.fromBytes(buffer);
        try {
            this.slot = WorkbenchPacketTweak.readString((FriendlyByteBuf)buffer);
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                this.tweaks.put(WorkbenchPacketTweak.readString((FriendlyByteBuf)buffer), buffer.readInt());
            }
        }
        catch (IOException e) {
            System.err.println("An error occurred when reading tweak packet from buffer");
        }
    }

    public void handle(Player player) {
        CastOptional.cast((Object)player.m_9236_().m_7702_(this.pos), WorkbenchTile.class).ifPresent(workbench -> workbench.tweak(player, this.slot, this.tweaks));
    }
}

