/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.InteractiveToolGui;

@ParametersAreNonnullByDefault
public class InteractiveOutlineGui
extends GuiElement {
    private static final ResourceLocation texture = new ResourceLocation("tetra", "textures/gui/block-interaction.png");
    private final BlockInteraction blockInteraction;
    private final GuiTexture topLeft;
    private final GuiTexture topRight;
    private final GuiTexture bottomLeft;
    private final GuiTexture bottomRight;
    private InteractiveToolGui tool;

    public InteractiveOutlineGui(BlockInteraction blockInteraction, Player player) {
        super((int)blockInteraction.minX * 4, (int)blockInteraction.minY * 4, (int)(blockInteraction.maxX - blockInteraction.minX) * 4, (int)(blockInteraction.maxY - blockInteraction.minY) * 4);
        this.blockInteraction = blockInteraction;
        this.opacity = 0.5f;
        this.topLeft = new GuiTexture(-2, -2, 4, 4, 0, 0, texture);
        this.addChild((GuiElement)this.topLeft);
        new KeyframeAnimation(100, (GuiElement)this.topLeft).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(0.0f, -2.0f), new Applier.TranslateY(0.0f, -2.0f)}).withDelay(500).start();
        this.topRight = new GuiTexture(2, -2, 4, 4, 3, 0, texture);
        this.topRight.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.topRight);
        new KeyframeAnimation(100, (GuiElement)this.topRight).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(0.0f, 2.0f), new Applier.TranslateY(0.0f, -2.0f)}).withDelay(650).start();
        this.bottomLeft = new GuiTexture(-2, 2, 4, 4, 3, 0, texture);
        this.bottomLeft.setAttachment(GuiAttachment.bottomLeft);
        this.addChild((GuiElement)this.bottomLeft);
        new KeyframeAnimation(100, (GuiElement)this.bottomLeft).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(0.0f, -2.0f), new Applier.TranslateY(0.0f, 2.0f)}).withDelay(500).start();
        this.bottomRight = new GuiTexture(2, 2, 4, 4, 0, 0, texture);
        this.bottomRight.setAttachment(GuiAttachment.bottomRight);
        this.addChild((GuiElement)this.bottomRight);
        new KeyframeAnimation(100, (GuiElement)this.bottomRight).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(0.0f, 2.0f), new Applier.TranslateY(0.0f, 2.0f)}).withDelay(650).onStop(complete -> {
            if (this.tool != null) {
                this.tool.updateFadeTime();
            }
        }).start();
        if (blockInteraction.requiredTool != null) {
            this.tool = new InteractiveToolGui(0, 0, blockInteraction.requiredTool, blockInteraction.requiredLevel, player);
            this.addChild(this.tool);
            float centerY = (float)this.y + (float)this.height / 2.0f;
            float centerX = (float)this.x + (float)this.width / 2.0f;
            if (Math.abs(centerX - 16.0f) > Math.abs(centerY - 16.0f)) {
                if (centerX < 16.0f) {
                    this.tool.setAttachmentPoint(GuiAttachment.middleLeft);
                    this.tool.setAttachmentAnchor(GuiAttachment.middleRight);
                    this.tool.setX(-1);
                } else {
                    this.tool.setAttachmentPoint(GuiAttachment.middleRight);
                    this.tool.setAttachmentAnchor(GuiAttachment.middleLeft);
                }
            } else if (centerY < 16.0f) {
                this.tool.setAttachmentPoint(GuiAttachment.topCenter);
                this.tool.setAttachmentAnchor(GuiAttachment.bottomCenter);
                this.tool.setY(1);
            } else {
                this.tool.setAttachmentPoint(GuiAttachment.bottomCenter);
                this.tool.setAttachmentAnchor(GuiAttachment.topCenter);
                this.tool.setY(-2);
            }
        }
    }

    protected void onFocus() {
        super.onFocus();
        if (this.tool != null) {
            this.tool.show();
        }
    }

    protected void onBlur() {
        super.onBlur();
        if (this.tool != null) {
            this.tool.hide();
        }
    }

    public BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    public void transitionOut(Runnable onStop) {
        new KeyframeAnimation(200, (GuiElement)this.topLeft).applyTo(new Applier[]{new Applier.Opacity(1.0f, 0.0f), new Applier.TranslateX(-5.0f), new Applier.TranslateY(-5.0f)}).start();
        new KeyframeAnimation(200, (GuiElement)this.topRight).applyTo(new Applier[]{new Applier.Opacity(1.0f, 0.0f), new Applier.TranslateX(5.0f), new Applier.TranslateY(-5.0f)}).start();
        new KeyframeAnimation(200, (GuiElement)this.bottomLeft).applyTo(new Applier[]{new Applier.Opacity(1.0f, 0.0f), new Applier.TranslateX(-5.0f), new Applier.TranslateY(5.0f)}).start();
        new KeyframeAnimation(200, (GuiElement)this.bottomRight).applyTo(new Applier[]{new Applier.Opacity(1.0f, 0.0f), new Applier.TranslateX(5.0f), new Applier.TranslateY(5.0f)}).onStop(finished -> onStop.run()).start();
    }
}

