/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.multischematic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.blocks.multischematic.MultiblockSchematicScrollPacket;
import se.mickelus.tetra.blocks.multischematic.StackedMultiblockSchematicItem;

public class MultiblockSchematicScrollHandler {
    private static final Map<String, List<StackedMultiblockSchematicItem>> schematics = new HashMap<String, List<StackedMultiblockSchematicItem>>();
    private static double scrollDelta;

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_7500_() && Screen.m_96639_() && player.m_21205_().m_41720_() instanceof StackedMultiblockSchematicItem) {
            double d = scrollDelta = Math.signum(scrollDelta) == Math.signum(event.getScrollDelta()) ? scrollDelta + event.getScrollDelta() : event.getScrollDelta();
            if (Math.abs(scrollDelta) > 1.0) {
                TetraMod.packetHandler.sendToServer((AbstractPacket)new MultiblockSchematicScrollPacket(scrollDelta > 0.0));
                scrollDelta = 0.0;
            }
            event.setCanceled(true);
        }
    }

    public static void shiftSchematic(Player player, boolean isIncrease) {
        if (player.m_7500_()) {
            CastOptional.cast((Object)player.m_21205_().m_41720_(), StackedMultiblockSchematicItem.class).ifPresent(item -> {
                List<StackedMultiblockSchematicItem> parts = schematics.get(item.schematicBlock.schematic);
                int index = parts.indexOf(item) + (isIncrease ? 1 : -1);
                if (index >= 0 && index < parts.size()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)parts.get(index)));
                }
            });
        }
    }

    public static void setupSchematic(String identifier, int partCount) {
        ArrayList<Object> list = new ArrayList<Object>(partCount);
        for (int i = 0; i < partCount; ++i) {
            list.add(i, null);
        }
        schematics.put(identifier, list);
    }

    public static void addSchematic(String identifier, int index, StackedMultiblockSchematicItem item) {
        schematics.get(identifier).set(index, item);
    }
}

