/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MenuScreenWrapper<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IScreenWrapper {
    private final BaseScreen wrappedGui;
    private boolean drawSlots = true;
    private final TooltipList tooltipList = new TooltipList();

    public MenuScreenWrapper(BaseScreen g, T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.wrappedGui = g;
    }

    public MenuScreenWrapper<T> disableSlotDrawing() {
        this.drawSlots = false;
        return this;
    }

    public void m_7856_() {
        super.m_7856_();
        this.wrappedGui.initGui();
        this.f_97735_ = this.wrappedGui.getX();
        this.f_97736_ = this.wrappedGui.getY();
        this.f_97726_ = this.wrappedGui.width;
        this.f_97727_ = this.wrappedGui.height;
    }

    public boolean m_7043_() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean m_6375_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        return this.wrappedGui.mousePressed(MouseButton.get(button)) || super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.m_6348_(x, y, button);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        return this.wrappedGui.mouseScrolled(scroll) || super.m_6050_(x, y, scroll);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
            return true;
        }
        if (this.wrappedGui.onClosedByKey(key)) {
            if (this.m_6913_()) {
                this.wrappedGui.closeGui(false);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.m_5534_(keyChar, (int)keyChar);
    }

    protected void m_7286_(GuiGraphics graphics, float f, int mx, int my) {
        Theme theme = this.wrappedGui.getTheme();
        GuiHelper.setupDrawing();
        this.m_280273_(graphics);
        GuiHelper.setupDrawing();
        this.wrappedGui.draw(graphics, theme, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        if (this.drawSlots) {
            GuiHelper.setupDrawing();
            for (Slot slot : this.f_97732_.f_38839_) {
                theme.drawContainerSlot(graphics, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, 16, 16);
            }
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)(-this.f_97735_), (float)(-this.f_97736_), 0.0f);
        GuiHelper.setupDrawing();
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.drawForeground(graphics, theme, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.wrappedGui.addMouseOverText(this.tooltipList);
        if (!this.tooltipList.shouldRender()) {
            this.wrappedGui.getIngredientUnderMouse().ifPresent(underMouse -> {
                ItemStack stack;
                Object ingredient;
                if (underMouse.tooltip() && (ingredient = underMouse.ingredient()) instanceof ItemStack && !(stack = (ItemStack)ingredient).m_41619_()) {
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(0.0f, 0.0f, (float)this.tooltipList.zOffsetItemTooltip);
                    graphics.m_280153_(theme.getFont(), (ItemStack)ingredient, mouseX, mouseY);
                    graphics.m_280168_().m_85849_();
                }
            });
        } else {
            List lines = Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)((Component)this.tooltipList.getLines().stream().reduce((c1, c2) -> c1.m_6881_().m_130946_("\n").m_7220_(c2)).orElse(Component.m_237119_())));
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 600.0f);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 0.8f);
            graphics.m_280547_(theme.getFont(), lines, DefaultTooltipPositioner.f_262752_, mouseX, Math.max(mouseY, 18));
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280168_().m_252880_(0.0f, 0.0f, -600.0f);
        }
        this.tooltipList.reset();
        graphics.m_280168_().m_85849_();
    }

    public void m_280273_(GuiGraphics graphics) {
        if (this.wrappedGui.drawDefaultBackground(graphics)) {
            super.m_280273_(graphics);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_181908_() {
        super.m_181908_();
        this.wrappedGui.tick();
    }

    @Override
    public BaseScreen getGui() {
        return this.wrappedGui;
    }

    public void m_7861_() {
        this.wrappedGui.onClosed();
        super.m_7861_();
    }

    public boolean m_6913_() {
        return this.getGui().shouldCloseOnEsc();
    }
}

