/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.network;

import com.glodblock.github.glodium.Glodium;
import com.glodblock.github.glodium.network.TargetPoint;
import com.glodblock.github.glodium.network.packet.IMessage;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkHandler {
    private final ResourceLocation channel;
    int id = 0;
    private final Consumer<IMessage<?>> clientHandler;
    private final Int2ObjectMap<Supplier<IMessage<?>>> packetFactoryMap = new Int2ObjectOpenHashMap();
    private final Object2IntMap<Class<?>> packetIDMap = new Object2IntOpenHashMap();

    public NetworkHandler(String modid) {
        this.channel = Glodium.id(modid, "network");
        EventNetworkChannel ec = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.channel).networkProtocolVersion(() -> "1").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).eventNetworkChannel();
        ec.addListener(this::clientPacket);
        ec.addListener(this::serverPacket);
        this.clientHandler = (Consumer)DistExecutor.unsafeRunForDist(() -> () -> NetworkHandler::onClientPacketData, () -> () -> pkt -> {});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onClientPacketData(IMessage<?> packet) {
        if (packet.isClient()) {
            packet.onMessage((Player)Minecraft.m_91087_().f_91074_);
        }
    }

    public void registerPacket(Class<?> clazz, Supplier<IMessage<?>> factory) {
        this.packetIDMap.put(clazz, this.id);
        this.packetFactoryMap.put(this.id, factory);
        ++this.id;
    }

    public void serverPacket(NetworkEvent.ClientCustomPayloadEvent ev) {
        try {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
            ctx.setPacketHandled(true);
            FriendlyByteBuf bytes = ev.getPayload();
            IMessage packet = (IMessage)((Supplier)this.packetFactoryMap.get(bytes.m_130242_())).get();
            packet.fromBytes(bytes);
            ServerPlayer player = ctx.getSender();
            ctx.enqueueWork(() -> {
                try {
                    packet.onMessage((Player)player);
                }
                catch (IllegalArgumentException e) {
                    Glodium.LOGGER.warn(e.getMessage());
                }
            });
        }
        catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
            // empty catch block
        }
    }

    public void clientPacket(NetworkEvent.ServerCustomPayloadEvent ev) {
        if (ev instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
            return;
        }
        if (this.clientHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
                ctx.setPacketHandled(true);
                FriendlyByteBuf bytes = ev.getPayload();
                IMessage packet = (IMessage)((Supplier)this.packetFactoryMap.get(bytes.m_130242_())).get();
                packet.fromBytes(bytes);
                ctx.enqueueWork(() -> this.clientHandler.accept(packet));
            }
            catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                // empty catch block
            }
        }
    }

    public void sendToAll(IMessage<?> message) {
        MinecraftServer server = Glodium.INSTANCE.getServer();
        if (server != null) {
            server.m_6846_().m_11268_(this.toFMLPacket(message, NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    public void sendTo(IMessage<?> message, ServerPlayer player) {
        player.f_8906_.m_9829_(this.toFMLPacket(message, NetworkDirection.PLAY_TO_CLIENT));
    }

    public void sendToAllAround(IMessage<?> message, TargetPoint point) {
        MinecraftServer server = Glodium.INSTANCE.getServer();
        if (server != null) {
            Packet<?> pkt = this.toFMLPacket(message, NetworkDirection.PLAY_TO_CLIENT);
            server.m_6846_().m_11241_((Player)point.excluded, point.x, point.y, point.z, point.r2, point.level.m_46472_(), pkt);
        }
    }

    public void sendToServer(IMessage<?> message) {
        assert (Minecraft.m_91087_().m_91403_() != null);
        Minecraft.m_91087_().m_91403_().m_104955_(this.toFMLPacket(message, NetworkDirection.PLAY_TO_SERVER));
    }

    public Packet<?> toFMLPacket(IMessage<?> message, NetworkDirection direction) {
        FriendlyByteBuf bytes = new FriendlyByteBuf(Unpooled.buffer((int)1024));
        int id = this.packetIDMap.getOrDefault(message.getPacketClass(), -1);
        if (id == -1) {
            Glodium.LOGGER.error(String.format("Unregistered Packet: %s", message.getPacketClass()));
        }
        bytes.m_130130_(id);
        message.toBytes(bytes);
        return direction.buildPacket(Pair.of((Object)bytes, (Object)0), this.channel).getThis();
    }
}

