/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.prism.util;

import com.adonis.prism.util.CasingHolder;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;

public class GlassBlockList<T extends Block> {
    public final Map<String, BlockEntry<T>> blockEntryMap = new HashMap<String, BlockEntry<T>>();

    public GlassBlockList(List<CasingHolder> holders, Function<CasingHolder, BlockEntry<T>> filler) {
        for (CasingHolder holder : holders) {
            this.blockEntryMap.put(holder.name(), filler.apply(holder));
        }
    }

    public BlockEntry<T>[] toArray() {
        BlockEntry[] blockEntries = new BlockEntry[this.blockEntryMap.size()];
        int i = 0;
        Iterator<BlockEntry<T>> iterator = this.blockEntryMap.values().iterator();
        while (iterator.hasNext()) {
            BlockEntry<T> value;
            blockEntries[i] = value = iterator.next();
            ++i;
        }
        return blockEntries;
    }

    public Block getCasing(String casingName) {
        BlockEntry<T> entry = this.blockEntryMap.get(casingName);
        return entry != null ? (Block)entry.get() : null;
    }

    public BlockEntry<T> getEntry(String casingName) {
        return this.blockEntryMap.get(casingName);
    }
}

