/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.prism.registry.builders;

import com.adonis.prism.CreatePrism;
import com.adonis.prism.block.glass.GlassCasing;
import com.adonis.prism.block.glass.GlassEncasedCTBehaviour;
import com.adonis.prism.block.glass.GlassEncasedCogCTBehaviour;
import com.adonis.prism.block.glass.GlassEncasedCogwheel;
import com.adonis.prism.block.glass.GlassEncasedShaft;
import com.adonis.prism.block.illumination.IlluminationCasing;
import com.adonis.prism.block.illumination.IlluminationEncasedCTBehaviour;
import com.adonis.prism.block.illumination.IlluminationEncasedCogCTBehaviour;
import com.adonis.prism.block.illumination.IlluminationEncasedCogwheel;
import com.adonis.prism.block.illumination.IlluminationEncasedShaft;
import com.adonis.prism.registry.CPSpriteShifts;
import com.adonis.prism.util.CasingHolder;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.MetalScaffoldingBlock;
import com.simibubi.create.content.decoration.MetalScaffoldingBlockItem;
import com.simibubi.create.content.decoration.MetalScaffoldingCTBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.palettes.AllPaletteBlocks;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.function.Consumer;
import net.createmod.catnip.data.Couple;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class GlassBlockBuilders {
    public static <T extends AbstractRegistrate<?>> BlockEntry<GlassCasing> glassCasing(T reg, CasingHolder holder, boolean clear) {
        String name = holder.name();
        String newName = name + (clear ? "_clear_glass_casing" : "_glass_casing");
        CTSpriteShiftEntry ctEntry = CPSpriteShifts.getCasingShift(name, clear);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(newName, GlassCasing::new).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60918_(SoundType.f_56744_).m_60955_()).properties(GlassBlockBuilders::glassProperties).addLayer(() -> RenderType::m_110463_).blockstate((c, p) -> p.simpleBlock((Block)c.get())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.makeCasing((Block)block, ctEntry)))).tag(new TagKey[]{AllTags.AllBlockTags.CASING.tag}).recipe((c, p) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)c.get())).m_126209_((ItemLike)holder.casing().get()).m_126209_((ItemLike)AllPaletteBlocks.FRAMED_GLASS.get()).m_126132_("has_casing", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_((TagKey)AllTags.AllItemTags.CASING.tag)).m_126140_((Consumer)p, CreatePrism.asResource("crafting/glass_casing/" + c.getName()))).item().tag(new TagKey[]{AllTags.AllItemTags.CASING.tag}).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<IlluminationCasing> illuminationCasing(T reg, CasingHolder holder) {
        String name = holder.name();
        String newName = name + "_illumination_casing";
        CTSpriteShiftEntry ctEntry = CPSpriteShifts.getIlluminationCasingShift(name);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(newName, IlluminationCasing::new).initialProperties(() -> Blocks.f_50141_).properties(p -> p.m_60918_(SoundType.f_56744_).m_60955_().m_60953_(s -> 15)).addLayer(() -> RenderType::m_110466_).blockstate((c, p) -> p.simpleBlock((Block)c.get())).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.makeCasing((Block)block, ctEntry)))).tag(new TagKey[]{AllTags.AllBlockTags.CASING.tag}).recipe((c, p) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)c.get())).m_126209_((ItemLike)holder.casing().get()).m_126211_((ItemLike)Items.f_42525_, 4).m_126132_("has_casing", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_((TagKey)AllTags.AllItemTags.CASING.tag)).m_126140_((Consumer)p, CreatePrism.asResource("crafting/illumination_casing/" + c.getName()))).item().tag(new TagKey[]{AllTags.AllItemTags.CASING.tag}).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<GlassEncasedShaft> glassEncasedShaft(T reg, String casing, boolean clear, NonNullFunction<BlockBehaviour.Properties, GlassEncasedShaft> factory) {
        String newName = casing + (clear ? "_clear_glass_encased_shaft" : "_glass_encased_shaft");
        CTSpriteShiftEntry ctEntry = CPSpriteShifts.getCasingShift(casing, clear);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(newName, factory).initialProperties(() -> Blocks.f_50058_).properties(BlockBehaviour.Properties::m_60955_).properties(GlassBlockBuilders::glassProperties).loot((p, lb) -> p.m_246125_((Block)lb, (ItemLike)AllBlocks.SHAFT.get())).addLayer(() -> RenderType::m_110463_).onRegister(CreateRegistrate.connectedTextures(() -> new GlassEncasedCTBehaviour(ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, ctEntry, (state, face) -> true)))).transform(TagGen.pickaxeOnly())).blockstate((ctx, prov) -> BlockStateGen.axisBlock((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, state -> ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), CreatePrism.asResource("block/glass_encased_shaft/block"))).texture("casing", CreatePrism.asResource("block/" + casing + (clear ? "_clear_glass" : "_glass") + "_casing"))).texture("opening", GlassBlockBuilders.getOpening(casing)), (boolean)true)).item().model((ctx, prov) -> ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), CreatePrism.asResource("block/glass_encased_shaft/block"))).texture("casing", CreatePrism.asResource("block/" + casing + (clear ? "_clear_glass" : "_glass") + "_casing"))).texture("opening", GlassBlockBuilders.getOpening(casing))).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<IlluminationEncasedShaft> illuminationEncasedShaft(T reg, String casing, NonNullFunction<BlockBehaviour.Properties, IlluminationEncasedShaft> factory) {
        String newName = casing + "_illumination_encased_shaft";
        CTSpriteShiftEntry ctEntry = CPSpriteShifts.getIlluminationCasingShift(casing);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(newName, factory).initialProperties(() -> Blocks.f_50141_).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_60953_(s -> 15)).properties(GlassBlockBuilders::glassProperties).loot((p, lb) -> p.m_246125_((Block)lb, (ItemLike)AllBlocks.SHAFT.get())).addLayer(() -> RenderType::m_110466_).onRegister(CreateRegistrate.connectedTextures(() -> new IlluminationEncasedCTBehaviour(ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, ctEntry, (state, face) -> true)))).transform(TagGen.pickaxeOnly())).blockstate((ctx, prov) -> BlockStateGen.axisBlock((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, state -> ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), CreatePrism.asResource("block/illumination_encased_shaft/block"))).texture("casing", CreatePrism.asResource("block/" + casing + "_illumination_casing"))).texture("opening", GlassBlockBuilders.getOpening(casing)), (boolean)true)).item().model((ctx, prov) -> ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), CreatePrism.asResource("block/illumination_encased_shaft/block"))).texture("casing", CreatePrism.asResource("block/" + casing + "_illumination_casing"))).texture("opening", GlassBlockBuilders.getOpening(casing))).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<GlassEncasedCogwheel> glassEncasedCogwheel(T reg, String casingType, boolean large, boolean clear, NonNullFunction<BlockBehaviour.Properties, GlassEncasedCogwheel> factory) {
        CTSpriteShiftEntry mainShift = CPSpriteShifts.getCasingShift(casingType, clear);
        String name = casingType + (clear ? "_clear" : "");
        String blockName = name + (large ? "_glass_encased_large_cogwheel" : "_glass_encased_cogwheel");
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(blockName, factory).initialProperties(() -> Blocks.f_50058_).properties(BlockBehaviour.Properties::m_60955_).properties(GlassBlockBuilders::glassProperties).loot((p, lb) -> {
            if (large) {
                p.m_246125_((Block)lb, (ItemLike)AllBlocks.LARGE_COGWHEEL.get());
            } else {
                p.m_246125_((Block)lb, (ItemLike)AllBlocks.COGWHEEL.get());
            }
        }).addLayer(() -> RenderType::m_110463_).onRegister(CreateRegistrate.connectedTextures(() -> GlassBlockBuilders.getCogCTBehaviour(mainShift, casingType, large)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, mainShift, (state, f) -> state.m_60734_() instanceof GlassEncasedCogwheel && f.m_122434_() == state.m_61143_((Property)GlassEncasedCogwheel.AXIS) && (Boolean)state.m_61143_((Property)(f.m_122421_() == Direction.AxisDirection.POSITIVE ? GlassEncasedCogwheel.TOP_SHAFT : GlassEncasedCogwheel.BOTTOM_SHAFT)) == false)))).transform(TagGen.pickaxeOnly())).blockstate((ctx, prov) -> BlockStateGen.axisBlock((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, blockState -> {
            String suffix = ((Boolean)blockState.m_61143_((Property)GlassEncasedCogwheel.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.m_61143_((Property)GlassEncasedCogwheel.BOTTOM_SHAFT) != false ? "_bottom" : "");
            String modelName = ctx.getName() + suffix;
            String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, CreatePrism.asResource("block/" + blockFolder + "/block" + suffix))).texture("particle", CreatePrism.asResource("block/" + name + "_glass_casing"))).texture("casing", CreatePrism.asResource("block/" + name + "_glass_casing"))).texture("backing", GlassBlockBuilders.getBacking(casingType))).texture("opening", GlassBlockBuilders.getOpening(casingType))).texture("siding", GlassBlockBuilders.getSiding(casingType, large));
        }, (boolean)false)).item().model((ctx, prov) -> {
            String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), CreatePrism.asResource("block/" + blockFolder + "/item"))).texture("casing", CreatePrism.asResource("block/" + name + "_glass_casing"))).texture("backing", GlassBlockBuilders.getBacking(casingType))).texture("opening", GlassBlockBuilders.getOpening(casingType))).texture("siding", GlassBlockBuilders.getSiding(casingType, large));
        }).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<IlluminationEncasedCogwheel> illuminationEncasedCogwheel(T reg, String casingType, boolean large, NonNullFunction<BlockBehaviour.Properties, IlluminationEncasedCogwheel> factory) {
        CTSpriteShiftEntry mainShift = CPSpriteShifts.getIlluminationCasingShift(casingType);
        String name = casingType + "_illumination";
        String blockName = name + (large ? "_encased_large_cogwheel" : "_encased_cogwheel");
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(blockName, factory).initialProperties(() -> Blocks.f_50141_).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_60953_(s -> 15)).properties(GlassBlockBuilders::glassProperties).loot((p, lb) -> {
            if (large) {
                p.m_246125_((Block)lb, (ItemLike)AllBlocks.LARGE_COGWHEEL.get());
            } else {
                p.m_246125_((Block)lb, (ItemLike)AllBlocks.COGWHEEL.get());
            }
        }).addLayer(() -> RenderType::m_110466_).onRegister(CreateRegistrate.connectedTextures(() -> GlassBlockBuilders.getIlluminationCogCTBehaviour(mainShift, casingType, large)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, mainShift, (state, f) -> state.m_60734_() instanceof IlluminationEncasedCogwheel && f.m_122434_() == state.m_61143_((Property)GlassEncasedCogwheel.AXIS) && (Boolean)state.m_61143_((Property)(f.m_122421_() == Direction.AxisDirection.POSITIVE ? GlassEncasedCogwheel.TOP_SHAFT : GlassEncasedCogwheel.BOTTOM_SHAFT)) == false)))).transform(TagGen.pickaxeOnly())).blockstate((ctx, prov) -> BlockStateGen.axisBlock((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, blockState -> {
            String suffix = ((Boolean)blockState.m_61143_((Property)GlassEncasedCogwheel.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.m_61143_((Property)GlassEncasedCogwheel.BOTTOM_SHAFT) != false ? "_bottom" : "");
            String modelName = ctx.getName() + suffix;
            String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, CreatePrism.asResource("block/" + blockFolder + "/block" + suffix))).texture("particle", CreatePrism.asResource("block/" + casingType + "_illumination_casing"))).texture("casing", CreatePrism.asResource("block/" + casingType + "_illumination_casing"))).texture("backing", GlassBlockBuilders.getBacking(casingType))).texture("opening", GlassBlockBuilders.getOpening(casingType))).texture("siding", GlassBlockBuilders.getIlluminationSiding(casingType, large));
        }, (boolean)false)).item().model((ctx, prov) -> {
            String blockFolder = large ? "encased_large_cogwheel" : "encased_cogwheel";
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), CreatePrism.asResource("block/" + blockFolder + "/item"))).texture("casing", CreatePrism.asResource("block/" + casingType + "_illumination_casing"))).texture("backing", GlassBlockBuilders.getBacking(casingType))).texture("opening", GlassBlockBuilders.getOpening(casingType))).texture("siding", GlassBlockBuilders.getIlluminationSiding(casingType, large));
        }).build()).register();
    }

    public static <T extends AbstractRegistrate<?>> BlockEntry<MetalScaffoldingBlock> glassScaffolding(T reg, String casing, boolean clear, NonNullFunction<BlockBehaviour.Properties, MetalScaffoldingBlock> factory) {
        String name = casing + (clear ? "_clear" : "") + "_glass_scaffolding";
        CTSpriteShiftEntry mainShift = CPSpriteShifts.getCasingShift(casing, clear);
        CTSpriteShiftEntry side = GlassBlockBuilders.getSideShift(casing);
        CTSpriteShiftEntry innerSide = GlassBlockBuilders.getInnerSideShift(casing);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(name, factory).initialProperties(() -> Blocks.f_50616_).properties(p -> p.m_60918_(SoundType.f_154663_).m_60955_()).addLayer(() -> RenderType::m_110463_).onRegister(CreateRegistrate.connectedTextures(() -> new MetalScaffoldingCTBehaviour(side, innerSide, mainShift)))).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{BlockTags.f_13082_}).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(s -> {
            String suffix = (Boolean)s.m_61143_((Property)MetalScaffoldingBlock.f_56014_) != false ? "_horizontal" : "";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + suffix, CreatePrism.asResource("block/scaffold/block" + suffix))).texture("top", GlassBlockBuilders.getTopTexture(casing))).texture("inside", GlassBlockBuilders.getInsideTexture(casing))).texture("side", GlassBlockBuilders.getSideTexture(casing))).texture("casing", CreatePrism.asResource("block/" + casing + (clear ? "_clear" : "") + "_glass_casing"))).texture("particle", GlassBlockBuilders.getSideTexture(casing))).build();
        }, new Property[]{MetalScaffoldingBlock.f_56013_, MetalScaffoldingBlock.f_56012_})).recipe((c, p) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)c.get())).m_126209_(GlassBlockBuilders.getScaffoldingBase(casing)).m_126209_((ItemLike)AllPaletteBlocks.FRAMED_GLASS.get()).m_126132_("has_scaffolding", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_(GlassBlockBuilders.getScaffoldingBase(casing))).m_126140_((Consumer)p, CreatePrism.asResource("crafting/glass_scaffolding/" + c.getName()))).item(MetalScaffoldingBlockItem::new).model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), CreatePrism.asResource("block/scaffold/item"))).texture("top", GlassBlockBuilders.getTopTexture(casing))).texture("inside", GlassBlockBuilders.getInsideTexture(casing))).texture("side", GlassBlockBuilders.getSideTexture(casing))).texture("casing", CreatePrism.asResource("block/" + casing + (clear ? "_clear" : "") + "_glass_casing"))).texture("particle", GlassBlockBuilders.getSideTexture(casing))).build()).register();
    }

    private static GlassEncasedCogCTBehaviour getCogCTBehaviour(CTSpriteShiftEntry mainShift, String casingType, boolean large) {
        if (!large) {
            CTSpriteShiftEntry side = CPSpriteShifts.vertical("encased_cogwheels/" + casingType + "_encased_cogwheel_side");
            CTSpriteShiftEntry otherSide = CPSpriteShifts.horizontal("encased_cogwheels/" + casingType + "_encased_cogwheel_side");
            Couple sideShifts = Couple.create((Object)side, (Object)otherSide);
            return new GlassEncasedCogCTBehaviour(mainShift, (Couple<CTSpriteShiftEntry>)sideShifts);
        }
        return new GlassEncasedCogCTBehaviour(mainShift);
    }

    private static IlluminationEncasedCogCTBehaviour getIlluminationCogCTBehaviour(CTSpriteShiftEntry mainShift, String casingType, boolean large) {
        if (!large) {
            CTSpriteShiftEntry side = CPSpriteShifts.vertical("encased_cogwheels/" + casingType + "_illumination_encased_cogwheel_side");
            CTSpriteShiftEntry otherSide = CPSpriteShifts.horizontal("encased_cogwheels/" + casingType + "_illumination_encased_cogwheel_side");
            Couple sideShifts = Couple.create((Object)side, (Object)otherSide);
            return new IlluminationEncasedCogCTBehaviour(mainShift, (Couple<CTSpriteShiftEntry>)sideShifts);
        }
        return new IlluminationEncasedCogCTBehaviour(mainShift);
    }

    private static BlockBehaviour.Properties glassProperties(BlockBehaviour.Properties p) {
        return p.m_60922_(($, $$, $$$, $$$$) -> false).m_60924_(($, $$, $$$) -> false).m_60960_(($, $$, $$$) -> false).m_60971_(($, $$, $$$) -> false);
    }

    private static ResourceLocation getOpening(String casing) {
        if (casing.equals("andesite")) {
            return new ResourceLocation("create", "block/gearbox");
        }
        if (casing.equals("brass")) {
            return new ResourceLocation("create", "block/brass_gearbox");
        }
        return CreatePrism.asResource("block/" + casing + "_gearbox");
    }

    private static ResourceLocation getBacking(String casing) {
        if (casing.equals("andesite")) {
            return new ResourceLocation("minecraft", "block/stripped_spruce_log_top");
        }
        if (casing.equals("brass")) {
            return new ResourceLocation("minecraft", "block/stripped_dark_oak_log_top");
        }
        return CreatePrism.asResource("block/" + casing + "_backing");
    }

    private static ResourceLocation getSiding(String casing, boolean large) {
        return CreatePrism.asResource("block/encased_cogwheels/" + (large ? "large_" : "") + casing + "_encased_cogwheel_side");
    }

    private static ResourceLocation getIlluminationSiding(String casing, boolean large) {
        return CreatePrism.asResource("block/encased_cogwheels/" + (large ? "large_" : "") + casing + "_illumination_encased_cogwheel_side");
    }

    private static CTSpriteShiftEntry getSideShift(String casing) {
        if (casing.equals("andesite")) {
            return AllSpriteShifts.ANDESITE_SCAFFOLD;
        }
        if (casing.equals("brass")) {
            return AllSpriteShifts.BRASS_SCAFFOLD;
        }
        if (casing.equals("copper")) {
            return AllSpriteShifts.COPPER_SCAFFOLD;
        }
        return CPSpriteShifts.horizontal("scaffold/" + casing + "_scaffold");
    }

    private static CTSpriteShiftEntry getInnerSideShift(String casing) {
        if (casing.equals("andesite")) {
            return AllSpriteShifts.ANDESITE_SCAFFOLD_INSIDE;
        }
        if (casing.equals("brass")) {
            return AllSpriteShifts.BRASS_SCAFFOLD_INSIDE;
        }
        if (casing.equals("copper")) {
            return AllSpriteShifts.COPPER_SCAFFOLD_INSIDE;
        }
        return CPSpriteShifts.horizontal("scaffold/" + casing + "_scaffold_inside");
    }

    private static ResourceLocation getTopTexture(String casing) {
        if (casing.equals("andesite") || casing.equals("brass") || casing.equals("copper")) {
            return new ResourceLocation("create", "block/funnel/" + casing + "_funnel_frame");
        }
        return CreatePrism.asResource("block/scaffold/" + casing + "_frame");
    }

    private static ResourceLocation getInsideTexture(String casing) {
        if (casing.equals("andesite") || casing.equals("brass") || casing.equals("copper")) {
            return new ResourceLocation("create", "block/scaffold/" + casing + "_scaffold_inside");
        }
        return CreatePrism.asResource("block/scaffold/" + casing + "_scaffold_inside");
    }

    private static ResourceLocation getSideTexture(String casing) {
        if (casing.equals("andesite") || casing.equals("brass") || casing.equals("copper")) {
            return new ResourceLocation("create", "block/scaffold/" + casing + "_scaffold");
        }
        return CreatePrism.asResource("block/scaffold/" + casing + "_scaffold");
    }

    private static BlockEntry<?> getScaffoldingBase(String casing) {
        if (casing.equals("andesite")) {
            return AllBlocks.ANDESITE_SCAFFOLD;
        }
        if (casing.equals("brass")) {
            return AllBlocks.BRASS_SCAFFOLD;
        }
        if (casing.equals("copper")) {
            return AllBlocks.COPPER_SCAFFOLD;
        }
        return AllBlocks.ANDESITE_SCAFFOLD;
    }
}

