/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.datagen.client.generators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lctech.client.resourcepacks.data.fluid_rendering.FluidRenderData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class FluidRenderDataProvider
implements DataProvider {
    protected final String modid;
    protected final PackOutput output;
    private final PackOutput.PathProvider pathProvider;
    private final Map<ResourceLocation, FluidRenderData> renderData = new HashMap<ResourceLocation, FluidRenderData>();

    protected FluidRenderDataProvider(PackOutput output, String modid) {
        this.modid = modid;
        this.output = output;
        this.pathProvider = output.m_245269_(PackOutput.Target.RESOURCE_PACK, "lctech/fluid_render_data");
    }

    protected abstract void addEntries();

    protected final void addData(String id, FluidRenderData data) {
        this.addData(VersionUtil.modResource((String)this.modid, (String)Objects.requireNonNull(id, "ID cannot be null!")), data);
    }

    protected final void addData(ResourceLocation id, FluidRenderData data) {
        this.renderData.put(Objects.requireNonNull(id, "ID cannot be null!"), Objects.requireNonNull(data, "Data cannot be null!"));
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.renderData.clear();
        this.addEntries();
        ArrayList results = new ArrayList();
        this.renderData.forEach((id, data) -> {
            JsonObject json = data.write();
            Path path = this.pathProvider.m_245731_(id);
            if (path == null) {
                results.add(CompletableFuture.completedFuture(null));
            } else {
                results.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])results.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "LC Tech Fluid Render Data: " + this.modid;
    }
}

