/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.fluid;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.TechConfig;
import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.items.FluidShardItem;
import io.github.lightman314.lctech.common.menu.traderstorage.fluid.FluidStorageTab;
import io.github.lightman314.lctech.common.menu.traderstorage.fluid.FluidTradeEditTab;
import io.github.lightman314.lctech.common.notifications.types.FluidTradeNotification;
import io.github.lightman314.lctech.common.traders.fluid.FluidInteractionSlot;
import io.github.lightman314.lctech.common.traders.fluid.TradeFluidHandler;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lctech.common.traders.fluid.settings.FluidTradeSettings;
import io.github.lightman314.lctech.common.traders.fluid.tradedata.FluidTradeData;
import io.github.lightman314.lctech.common.upgrades.TechUpgradeTypes;
import io.github.lightman314.lctech.common.util.FluidItemUtil;
import io.github.lightman314.lctech.common.util.icons.FluidIcon;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.stats.StatKeys;
import io.github.lightman314.lightmanscurrency.api.traders.IFlexibleOfferTrader;
import io.github.lightman314.lightmanscurrency.api.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveTradeNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.TradeOfferUpgrade;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidTraderData
extends InputTraderData
implements TraderFluidStorage.ITraderFluidFilter,
IFlexibleOfferTrader {
    public static final TraderType<FluidTraderData> TYPE = new TraderType(new ResourceLocation("lctech", "fluid_trader"), FluidTraderData::new);
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{TechUpgradeTypes.FLUID_CAPACITY});
    public final TradeFluidHandler fluidHandler = new TradeFluidHandler(this);
    TraderFluidStorage storage = new TraderFluidStorage(this);
    private int baseTradeCount = 0;
    List<FluidTradeData> trades = FluidTradeData.listOfSize(1, true);

    public TraderFluidStorage getStorage() {
        return this.storage;
    }

    public void markStorageDirty() {
        this.markDirty(new Consumer[]{this::saveStorage});
    }

    public final boolean drainCapable() {
        return !this.showOnTerminal();
    }

    protected boolean allowVoidUpgrade() {
        return true;
    }

    private FluidTraderData() {
        super(TYPE);
    }

    public FluidTraderData(int tradeCount, Level level, BlockPos pos) {
        super(TYPE, level, pos);
        this.trades = FluidTradeData.listOfSize(tradeCount, true);
        this.baseTradeCount = tradeCount;
    }

    public List<TradeDirection> validDirectionOptions() {
        return ImmutableList.of((Object)TradeDirection.SALE, (Object)TradeDirection.PURCHASE);
    }

    protected void registerNodes(Consumer<SettingsNode> builder) {
        super.registerNodes(builder);
        builder.accept((SettingsNode)new FluidTradeSettings(this));
    }

    protected void loadAdditional(CompoundTag compound) {
        super.loadAdditional(compound);
        if (compound.m_128425_("Trades", 9)) {
            this.trades = FluidTradeData.LoadNBTList(compound, !this.isPersistent());
        }
        if (compound.m_128441_("FluidStorage")) {
            this.storage.load(compound, "FluidStorage");
        }
        if (compound.m_128441_("BaseTradeCount")) {
            this.baseTradeCount = compound.m_128451_("BaseTradeCount");
        }
        if (this.baseTradeCount <= 0) {
            this.baseTradeCount = this.trades.size();
        }
    }

    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        this.saveTrades(compound);
        this.saveStorage(compound);
    }

    protected final void saveTrades(CompoundTag compound) {
        compound.m_128405_("BaseTradeCount", this.baseTradeCount);
        FluidTradeData.WriteNBTList(this.trades, compound);
    }

    protected final void saveStorage(CompoundTag compound) {
        this.storage.save(compound, "FluidStorage");
    }

    public int getTradeCount() {
        return this.trades.size();
    }

    public void addTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (LCAdminMode.isAdminPlayer((Player)requestor) && this.baseTradeCount < 100) {
            ++this.baseTradeCount;
            this.refactorTrades();
            this.pushLocalNotification((Notification)new AddRemoveTradeNotification(PlayerReference.of((Player)requestor), true, this.getTradeCount()));
        } else {
            Permissions.PermissionWarning((Player)requestor, (String)"add a trade slot", (String)"LC_ADMIN_MODE");
        }
    }

    public void removeTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (LCAdminMode.isAdminPlayer((Player)requestor) && this.baseTradeCount > 1) {
            --this.baseTradeCount;
            this.refactorTrades();
            this.pushLocalNotification((Notification)new AddRemoveTradeNotification(PlayerReference.of((Player)requestor), false, this.getTradeCount()));
        } else {
            Permissions.PermissionWarning((Player)requestor, (String)"remove a trade slot", (String)"LC_ADMIN_MODE");
        }
    }

    public void refactorTrades() {
        int newCount = MathUtil.clamp((int)(this.baseTradeCount + TradeOfferUpgrade.getBonusTrades((Container)this.getUpgrades())), (int)1, (int)100);
        if (newCount != this.trades.size()) {
            this.overrideTradeCount(newCount);
        }
    }

    public void overrideTradeCount(int newTradeCount) {
        int tradeCount = MathUtil.clamp((int)newTradeCount, (int)1, (int)100);
        if (this.trades.size() == tradeCount) {
            return;
        }
        List<FluidTradeData> oldTrades = this.trades;
        this.trades = FluidTradeData.listOfSize(tradeCount, !this.isPersistent());
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        if (this.isServer()) {
            this.markTradesDirty();
        }
    }

    public FluidTradeData getTrade(int tradeIndex) {
        if (tradeIndex >= 0 && tradeIndex < this.trades.size()) {
            return this.trades.get(tradeIndex);
        }
        return new FluidTradeData(false);
    }

    public int getTradeStock(int index) {
        return this.getTrade(index).getStock(this);
    }

    public List<FluidTradeData> getTradeData() {
        return new ArrayList<FluidTradeData>(this.trades);
    }

    public TradeFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public List<FluidStack> getRelevantFluids() {
        ArrayList<FluidStack> result = new ArrayList<FluidStack>();
        for (FluidTradeData trade : this.getTradeData()) {
            FluidStack product = trade.getProduct();
            if (product.isEmpty()) continue;
            FluidItemUtil.addFluidToRelevanceList(result, product);
        }
        return result;
    }

    public static int getDefaultTankCapacity() {
        return (Integer)TechConfig.SERVER.fluidTraderDefaultStorage.get() * 1000;
    }

    @Override
    public int getTankCapacity() {
        int defaultCapacity;
        int tankCapacity = defaultCapacity = FluidTraderData.getDefaultTankCapacity();
        boolean baseStorageCompensation = false;
        for (int i = 0; i < this.getUpgrades().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || upgradeItem.getUpgradeType() != TechUpgradeTypes.FLUID_CAPACITY) continue;
            int addAmount = UpgradeItem.getUpgradeData((ItemStack)stack).getIntValue(CapacityUpgrade.CAPACITY);
            if (addAmount > defaultCapacity && !baseStorageCompensation) {
                addAmount -= defaultCapacity;
                baseStorageCompensation = true;
            }
            tankCapacity += addAmount;
        }
        return tankCapacity;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction relativeSide) {
        return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.getFluidHandler().getExternalHandler(relativeSide)));
    }

    public IconData inputSettingsTabIcon() {
        return IconData.of((ItemLike)Items.f_42447_);
    }

    public MutableComponent inputSettingsTabTooltip() {
        return TechText.TOOLTIP_SETTINGS_INPUT_FLUID.get(new Object[0]);
    }

    public TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        FluidTradeData trade = this.getTrade(tradeIndex);
        if (trade == null || !trade.isValid()) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(trade, context).isCanceled()) {
            return TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        MoneyValue price = trade.getCost(context);
        if (!trade.hasStock(context) && !this.isCreative()) {
            return TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (trade.isSale()) {
            TraderFluidStorage.FluidEntry tankEntry = this.getStorage().getTank(trade.getProduct());
            if (!(context.canFitFluid(trade.productOfQuantity()) || this.hasOutputSide() && tankEntry != null && tankEntry.drainable)) {
                return TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.getPayment(price)) {
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            boolean drainTank = true;
            if (context.canFitFluid(trade.productOfQuantity())) {
                context.fillFluid(trade.productOfQuantity());
            } else {
                drainTank = false;
                tankEntry.addPendingDrain(trade.getQuantity());
                this.markStorageDirty();
            }
            MoneyValue taxesPaid = MoneyValue.empty();
            if (this.canStoreMoney()) {
                taxesPaid = this.addStoredMoney(price, true);
            }
            if (!this.isCreative() && drainTank) {
                this.getStorage().drain(trade.productOfQuantity());
                this.markStorageDirty();
            }
            this.incrementStat(StatKeys.Traders.MONEY_EARNED, price);
            if (!taxesPaid.isEmpty()) {
                this.incrementStat(StatKeys.Taxables.TAXES_PAID, taxesPaid);
            }
            this.pushNotification(FluidTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(trade, context, price, taxesPaid);
            return TradeResult.SUCCESS;
        }
        if (trade.isPurchase()) {
            if (!context.hasFluid(trade.productOfQuantity())) {
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.isCreative()) {
                return TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!context.givePayment(price)) {
                return TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.drainFluid(trade.productOfQuantity())) {
                context.getPayment(price);
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            MoneyValue taxesPaid = MoneyValue.empty();
            if (this.shouldStoreGoods()) {
                this.getStorage().forceFillTank(trade.productOfQuantity());
                this.markStorageDirty();
            }
            if (!this.isCreative()) {
                taxesPaid = this.removeStoredMoney(price, true);
            }
            this.incrementStat(StatKeys.Traders.MONEY_PAID, price);
            if (!taxesPaid.isEmpty()) {
                this.incrementStat(StatKeys.Taxables.TAXES_PAID, taxesPaid);
            }
            this.pushNotification(FluidTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(trade, context, price, taxesPaid);
            return TradeResult.SUCCESS;
        }
        return TradeResult.FAIL_INVALID_TRADE;
    }

    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
        interactionSlots.add(FluidInteractionSlot.INSTANCE);
    }

    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public boolean canMakePersistent() {
        return true;
    }

    protected void getAdditionalContents(List<ItemStack> results) {
        for (TraderFluidStorage.FluidEntry entry : this.storage.getContents()) {
            if (entry.getTankContents().isEmpty()) continue;
            results.add(FluidShardItem.GetFluidShard(entry.getTankContents()));
        }
    }

    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42447_);
    }

    public boolean hasValidTrade() {
        for (FluidTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            return true;
        }
        return false;
    }

    public void initStorageTabs(ITraderStorageMenu menu) {
        menu.setTab(1, (TraderStorageTab)new FluidStorageTab(menu));
        menu.setTab(2, (TraderStorageTab)new FluidTradeEditTab(menu));
    }

    protected void loadAdditionalFromJson(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        if (!json.has("Trades")) {
            throw new JsonSyntaxException("Fluid Trader must have a trade list.");
        }
        JsonArray tradeList = GsonHelper.m_13933_((JsonObject)json, (String)"Trades");
        this.trades = new ArrayList<FluidTradeData>();
        for (int i = 0; i < tradeList.size() && this.trades.size() < 100; ++i) {
            try {
                JsonObject tradeData = tradeList.get(i).getAsJsonObject();
                FluidTradeData newTrade = new FluidTradeData(false);
                JsonObject product = GsonHelper.m_13930_((JsonObject)tradeData, (String)"Product");
                newTrade.setProduct(FluidItemUtil.parseFluidStack(product));
                if (tradeData.has("TradeType")) {
                    newTrade.setTradeDirection(FluidTradeData.loadTradeType(tradeData.get("TradeType").getAsString()));
                }
                newTrade.setCost(MoneyValue.loadFromJson((JsonElement)tradeData.get("Price")));
                if (tradeData.has("Quantity")) {
                    newTrade.setBucketQuantity(GsonHelper.m_13927_((JsonObject)tradeData, (String)"Quantity"));
                }
                if (tradeData.has("TradeRules")) {
                    newTrade.setRules(TradeRule.Parse((JsonArray)GsonHelper.m_13933_((JsonObject)tradeData, (String)"TradeRules"), (ITradeRuleHost)newTrade));
                }
                this.trades.add(newTrade);
                continue;
            }
            catch (Exception e) {
                LCTech.LOGGER.error("Error parsing fluid trade at index {}", (Object)i, (Object)e);
            }
        }
        if (this.trades.isEmpty()) {
            throw new JsonSyntaxException("Trader has no valid trades!");
        }
    }

    protected void saveAdditionalToJson(JsonObject json) {
        JsonArray trades = new JsonArray();
        for (FluidTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            tradeData.addProperty("TradeType", trade.getTradeDirection().name());
            tradeData.add("Price", (JsonElement)trade.getCost().toJson());
            tradeData.add("Product", (JsonElement)FluidItemUtil.convertFluidStack(trade.getProduct()));
            tradeData.addProperty("Quantity", (Number)trade.getBucketQuantity());
            if (!trade.getRules().isEmpty()) {
                tradeData.add("TradeRules", (JsonElement)TradeRule.saveRulesToJson((List)trade.getRules()));
            }
            trades.add((JsonElement)tradeData);
        }
        json.add("Trades", (JsonElement)trades);
    }

    protected void saveAdditionalPersistentData(CompoundTag compound) {
        ListTag tradePersistentData = new ListTag();
        boolean tradesAreRelevant = false;
        Iterator<FluidTradeData> iterator = this.trades.iterator();
        while (iterator.hasNext()) {
            CompoundTag ptTag = new CompoundTag();
            FluidTradeData trade = iterator.next();
            if (TradeRule.savePersistentData((CompoundTag)ptTag, (List)trade.getRules(), (String)"RuleData")) {
                tradesAreRelevant = true;
            }
            tradePersistentData.add((Object)ptTag);
        }
        if (tradesAreRelevant) {
            compound.m_128365_("PersistentTradeData", (Tag)tradePersistentData);
        }
    }

    protected void loadAdditionalPersistentData(CompoundTag compound) {
        if (compound.m_128441_("PersistentTradeData")) {
            ListTag tradePersistentData = compound.m_128437_("PersistentTradeData", 10);
            for (int i = 0; i < tradePersistentData.size() && i < this.trades.size(); ++i) {
                FluidTradeData trade = this.trades.get(i);
                CompoundTag ptTag = tradePersistentData.m_128728_(i);
                TradeRule.loadPersistentData((CompoundTag)ptTag, (List)trade.getRules(), (String)"RuleData");
            }
        }
    }

    protected void appendTerminalInfo(List<Component> list, @Nullable Player player) {
        int tradeCount = 0;
        int outOfStock = 0;
        for (FluidTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            ++tradeCount;
            if (this.isCreative() || trade.hasStock(this)) continue;
            ++outOfStock;
        }
        list.add((Component)LCText.TOOLTIP_NETWORK_TERMINAL_TRADE_COUNT.get(new Object[]{tradeCount}));
        if (outOfStock > 0) {
            list.add((Component)LCText.TOOLTIP_NETWORK_TERMINAL_OUT_OF_STOCK_COUNT.get(new Object[]{outOfStock}));
        }
    }

    public IconData getIconForItem(ItemStack stack, IconData originalIcon) {
        FluidStack fluid = FluidTraderData.findFluid((LazyOptional<? extends IFluidHandler>)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM));
        if (fluid == null) {
            fluid = FluidTraderData.findFluid((LazyOptional<? extends IFluidHandler>)stack.getCapability(ForgeCapabilities.FLUID_HANDLER));
        }
        if (fluid != null && !fluid.isEmpty()) {
            FluidIcon fi;
            fluid.setAmount(1000);
            FluidIcon newIcon = FluidIcon.of(fluid);
            if (originalIcon instanceof FluidIcon && newIcon.matches(fi = (FluidIcon)originalIcon)) {
                return super.getIconForItem(stack, originalIcon);
            }
            return newIcon;
        }
        return super.getIconForItem(stack, originalIcon);
    }

    @Nullable
    private static FluidStack findFluid(LazyOptional<? extends IFluidHandler> optional) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        optional.ifPresent(handler -> {
            for (int i = 0; i < handler.getTanks() && result.get() == null; ++i) {
                FluidStack contents = handler.getFluidInTank(i);
                if (contents.isEmpty()) continue;
                result.set(contents.copy());
            }
        });
        return result.get();
    }
}

