/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderstorage.fluid;

import io.github.lightman314.lctech.LCTech;
import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.fluid.FluidStorageClientTab;
import io.github.lightman314.lctech.common.traders.fluid.FluidTraderData;
import io.github.lightman314.lctech.common.traders.fluid.TraderFluidStorage;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.slot.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidStorageTab
extends TraderStorageTab {
    List<EasySlot> slots = new ArrayList<EasySlot>();

    public FluidStorageTab(ITraderStorageMenu menu) {
        super(menu);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new FluidStorageClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            for (int i = 0; i < trader.getUpgrades().m_6643_(); ++i) {
                UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(trader.getUpgrades(), i, 176, 18 + 18 * i, (IUpgradeable)trader);
                upgradeSlot.active = false;
                addSlot.apply((Slot)upgradeSlot);
                this.slots.add((EasySlot)upgradeSlot);
            }
        }
    }

    public void onTabClose() {
        EasySlot.SetInactive(this.slots);
    }

    public void onTabOpen() {
        EasySlot.SetActive(this.slots);
    }

    public void interactWithTank(int tank, boolean shiftHeld) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            LCTech.LOGGER.debug("Fluid Tank Interaction. Tank {} on {}", (Object)tank, (Object)DebugUtil.getSideText((boolean)((ITraderStorageMenu)this.menu).isClient()));
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(LazyPacketData.builder().setInt("InteractWithTank", tank).setBoolean("ShiftHeld", shiftHeld));
                return;
            }
            ItemStack heldStack = ((ITraderStorageMenu)this.menu).getHeldItem();
            if (heldStack.m_41619_()) {
                return;
            }
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)heldStack, (IFluidHandler)trader.getStorage(), (int)Integer.MAX_VALUE, (Player)((ITraderStorageMenu)this.menu).getPlayer(), (boolean)true);
            if (result.isSuccess()) {
                if (((ITraderStorageMenu)this.menu).getPlayer().m_7500_() && result.getResult().m_41720_() == Items.f_42446_) {
                    if (shiftHeld) {
                        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)heldStack).orElse(FluidStack.EMPTY);
                        TraderFluidStorage.FluidEntry entry = trader.getStorage().getTank(fluid);
                        if (entry != null) {
                            entry.setAmount(trader.getTankCapacity());
                        }
                    }
                    trader.markStorageDirty();
                    return;
                }
                trader.markStorageDirty();
                if (heldStack.m_41613_() > 1) {
                    heldStack.m_41774_(1);
                    ((ITraderStorageMenu)this.menu).setHeldItem(heldStack);
                    ItemHandlerHelper.giveItemToPlayer((Player)((ITraderStorageMenu)this.menu).getPlayer(), (ItemStack)result.getResult());
                } else {
                    ((ITraderStorageMenu)this.menu).setHeldItem(result.getResult());
                }
            } else {
                if (tank < 0 || tank >= trader.getStorage().getTanks()) {
                    return;
                }
                TraderFluidStorage.FluidEntry tankEntry = trader.getStorage().getContents().get(tank);
                result = FluidUtil.tryFillContainer((ItemStack)heldStack, (IFluidHandler)tankEntry, (int)Integer.MAX_VALUE, (Player)((ITraderStorageMenu)this.menu).getPlayer(), (boolean)true);
                if (result.isSuccess()) {
                    if (((ITraderStorageMenu)this.menu).getPlayer().m_7500_() && heldStack.m_41720_() == Items.f_42446_) {
                        if (shiftHeld) {
                            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)result.getResult()).orElse(FluidStack.EMPTY);
                            TraderFluidStorage.FluidEntry entry = trader.getStorage().getTank(fluid);
                            if (entry != null) {
                                entry.setAmount(0);
                            }
                        }
                        trader.getStorage().clearInvalidTanks();
                        trader.markStorageDirty();
                        return;
                    }
                    trader.getStorage().clearInvalidTanks();
                    trader.markStorageDirty();
                    if (heldStack.m_41613_() > 1) {
                        heldStack.m_41774_(1);
                        ((ITraderStorageMenu)this.menu).setHeldItem(heldStack);
                        ItemHandlerHelper.giveItemToPlayer((Player)((ITraderStorageMenu)this.menu).getPlayer(), (ItemStack)result.getResult());
                    } else {
                        ((ITraderStorageMenu)this.menu).setHeldItem(result.getResult());
                    }
                }
            }
        }
    }

    public void toggleDrainFillState(int tank, boolean drainState, boolean newValue) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof FluidTraderData) {
            FluidTraderData trader = (FluidTraderData)traderData;
            if (!trader.drainCapable()) {
                return;
            }
            if (tank < 0 || tank >= trader.getStorage().getTanks()) {
                return;
            }
            TraderFluidStorage.FluidEntry entry = trader.getStorage().getContents().get(tank);
            if (drainState) {
                entry.drainable = newValue;
            } else {
                entry.fillable = newValue;
            }
            trader.markStorageDirty();
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(LazyPacketData.builder().setInt("ToggleDrainFillSlot", tank).setBoolean("DrainState", drainState).setBoolean("NewValue", newValue));
            }
        }
    }

    public void receiveMessage(LazyPacketData message) {
        if (message.contains("InteractWithTank", (byte)2)) {
            this.interactWithTank(message.getInt("InteractWithTank"), message.getBoolean("ShiftHeld"));
        } else if (message.contains("ToggleDrainFillSlot", (byte)2)) {
            int tank = message.getInt("ToggleDrainFillSlot");
            boolean drainState = message.getBoolean("DrainState");
            boolean newValue = message.getBoolean("NewValue");
            this.toggleDrainFillState(tank, drainState, newValue);
        }
    }
}

