/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderstorage.energy;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderstorage.energy.EnergyStorageClientTab;
import io.github.lightman314.lctech.common.menu.slots.BatteryInputSlot;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.slot.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnergyStorageTab
extends TraderStorageTab {
    List<EasySlot> slots = new ArrayList<EasySlot>();
    BatteryInputSlot drainSlot;
    BatteryInputSlot fillSlot;
    Container batterySlots = new SimpleContainer(2);

    public EnergyStorageTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new EnergyStorageClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof EnergyTraderData) {
            EnergyTraderData trader = (EnergyTraderData)traderData;
            for (int i = 0; i < trader.getUpgrades().m_6643_(); ++i) {
                UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(trader.getUpgrades(), i, 176, 18 + 18 * i, (IUpgradeable)trader);
                upgradeSlot.active = false;
                addSlot.apply((Slot)upgradeSlot);
                this.slots.add((EasySlot)upgradeSlot);
            }
        }
        this.drainSlot = new BatteryInputSlot(this.batterySlots, 0, 23, 122);
        this.drainSlot.requireEnergy = true;
        this.slots.add(this.drainSlot);
        addSlot.apply((Slot)this.drainSlot);
        this.drainSlot.locked = true;
        this.fillSlot = new BatteryInputSlot(this.batterySlots, 1, 59, 122);
        this.slots.add(this.fillSlot);
        addSlot.apply((Slot)this.fillSlot);
        this.fillSlot.locked = true;
        EasySlot.SetInactive(this.slots);
    }

    public void onTabClose() {
        EasySlot.SetInactive(this.slots);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.drainSlot.locked = true;
        this.fillSlot.locked = true;
    }

    public void onMenuClose() {
        ((ITraderStorageMenu)this.menu).clearContainer(this.batterySlots);
    }

    public void onTabOpen() {
        EasySlot.SetActive(this.slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.drainSlot.locked = false;
        this.fillSlot.locked = false;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        TraderData traderData;
        if (event.side.isServer() && event.phase == TickEvent.Phase.START && (traderData = ((ITraderStorageMenu)this.menu).getTrader()) instanceof EnergyTraderData) {
            ItemStack batteryStack;
            EnergyTraderData trader = (EnergyTraderData)traderData;
            if (!this.batterySlots.m_8020_(0).m_41619_() && (batteryStack = this.batterySlots.m_8020_(0)).m_41613_() == 1) {
                EnergyUtil.getEnergyHandler(batteryStack).ifPresent(energyStorage -> {
                    int extractedAmount = energyStorage.extractEnergy(trader.getMaxEnergy() - trader.getTotalEnergy(), false);
                    if (extractedAmount > 0) {
                        trader.addEnergy(extractedAmount);
                    }
                });
            }
            if (!this.batterySlots.m_8020_(1).m_41619_() && (batteryStack = this.batterySlots.m_8020_(1)).m_41613_() == 1) {
                EnergyUtil.getEnergyHandler(batteryStack).ifPresent(energyStorage -> {
                    int drainedAmount = energyStorage.receiveEnergy(trader.getAvailableEnergy(), false);
                    if (drainedAmount > 0) {
                        trader.shrinkEnergy(drainedAmount);
                    }
                });
            }
        }
    }

    public void receiveMessage(@Nonnull LazyPacketData lazyPacketData) {
    }
}

