/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.menu.traderinterface.energy;

import io.github.lightman314.lctech.client.gui.screen.inventory.traderinterface.energy.EnergyStorageClientTab;
import io.github.lightman314.lctech.common.blockentities.EnergyTraderInterfaceBlockEntity;
import io.github.lightman314.lctech.common.menu.slots.BatteryInputSlot;
import io.github.lightman314.lctech.common.menu.util.MenuUtil;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.api.upgrades.slot.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnergyStorageTab
extends TraderInterfaceTab {
    List<EasySlot> slots = new ArrayList<EasySlot>();
    BatteryInputSlot drainSlot;
    BatteryInputSlot fillSlot;
    Container batterySlots = new SimpleContainer(2);

    public EnergyStorageTab(TraderInterfaceMenu menu) {
        super(menu);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new EnergyStorageClientTab(screen, this);
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    public boolean canOpen(Player player) {
        return true;
    }

    public void onTabOpen() {
        EasySlot.SetActive(this.slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.drainSlot.locked = false;
        this.fillSlot.locked = false;
    }

    public void onTabClose() {
        EasySlot.SetInactive(this.slots);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.drainSlot.locked = true;
        this.fillSlot.locked = true;
    }

    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        for (int i = 0; i < ((TraderInterfaceMenu)this.menu).getBE().getUpgrades().m_6643_(); ++i) {
            UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(((TraderInterfaceMenu)this.menu).getBE().getUpgrades(), i, 176, 18 + 18 * i, (IUpgradeable)((TraderInterfaceMenu)this.menu).getBE());
            upgradeSlot.active = false;
            upgradeSlot.setListener(this::onUpgradeModified);
            addSlot.apply((Slot)upgradeSlot);
            this.slots.add((EasySlot)upgradeSlot);
        }
        this.drainSlot = new BatteryInputSlot(this.batterySlots, 0, 23, 122);
        this.drainSlot.requireEnergy = true;
        this.slots.add(this.drainSlot);
        addSlot.apply((Slot)this.drainSlot);
        this.drainSlot.locked = true;
        this.fillSlot = new BatteryInputSlot(this.batterySlots, 1, 59, 122);
        this.slots.add(this.fillSlot);
        addSlot.apply((Slot)this.fillSlot);
        this.fillSlot.locked = true;
        EasySlot.SetInactive(this.slots);
    }

    private void onUpgradeModified() {
        ((TraderInterfaceMenu)this.menu).getBE().setUpgradeSlotsDirty();
    }

    public void onMenuClose() {
        MenuUtil.clearContainer(((TraderInterfaceMenu)this.menu).player, this.batterySlots);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (event.side.isServer() && event.phase == TickEvent.Phase.START && (traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE()) instanceof EnergyTraderInterfaceBlockEntity) {
            ItemStack batteryStack;
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            if (!this.batterySlots.m_8020_(0).m_41619_() && (batteryStack = this.batterySlots.m_8020_(0)).m_41613_() == 1) {
                EnergyUtil.getEnergyHandler(batteryStack).ifPresent(energyStorage -> {
                    int extractedAmount = energyStorage.extractEnergy(be.getMaxEnergy() - be.getStoredEnergy(), false);
                    if (extractedAmount > 0) {
                        be.addStoredEnergy(extractedAmount);
                    }
                });
            }
            if (!this.batterySlots.m_8020_(1).m_41619_() && (batteryStack = this.batterySlots.m_8020_(1)).m_41613_() == 1) {
                EnergyUtil.getEnergyHandler(batteryStack).ifPresent(energyStorage -> {
                    int drainedAmount = energyStorage.receiveEnergy(be.getStoredEnergy(), false);
                    if (drainedAmount > 0) {
                        be.drainStoredEnergy(drainedAmount);
                    }
                });
            }
        }
    }

    public void toggleSide(Direction side, DirectionalSettingsState state) {
        TraderInterfaceBlockEntity traderInterfaceBlockEntity;
        if (((TraderInterfaceMenu)this.menu).getBE().canAccess(((TraderInterfaceMenu)this.menu).player) && (traderInterfaceBlockEntity = ((TraderInterfaceMenu)this.menu).getBE()) instanceof EnergyTraderInterfaceBlockEntity) {
            EnergyTraderInterfaceBlockEntity be = (EnergyTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            be.getEnergyHandler().toggleSide(side, state);
            be.setHandlerDirty((SidedHandler)be.getEnergyHandler());
        }
    }

    public void handleMessage(@Nonnull LazyPacketData lazyPacketData) {
    }
}

