/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.utils;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.AllayDuplicationRecipe;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TamingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.recipe.TransformationRecipe;
import com.christofmeg.justenoughbreeding.recipe.TrustingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static Ingredient createCombinedIngredient(String mobIngredients) {
        String[] ingredientIds = mobIngredients.split(",");
        ArrayList<Ingredient> combinedIngredients = new ArrayList<Ingredient>();
        for (String ingredientId : ingredientIds) {
            if (ingredientId.trim().startsWith("#")) {
                combinedIngredients.add(CommonUtils.createTagIngredient(ingredientId));
                continue;
            }
            Item ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(new ResourceLocation(ingredientId.trim()));
            if (ingredientItem == null) continue;
            combinedIngredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ingredientItem)}));
        }
        return Ingredient.merge(combinedIngredients);
    }

    public static Ingredient createCombinedIngredientFromTag(String mobIngredients) {
        ArrayList<Ingredient> combinedIngredients = new ArrayList<Ingredient>();
        ResourceLocation tagLocation = new ResourceLocation(mobIngredients.trim());
        combinedIngredients.add(Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLocation)));
        return Ingredient.merge(combinedIngredients);
    }

    public static Ingredient createCombinedIngredient(String mobIngredients, int amount, CompoundTag nbt) {
        ArrayList<Ingredient> combinedIngredients = new ArrayList<Ingredient>();
        Item ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(new ResourceLocation(mobIngredients.trim()));
        if (ingredientItem != null) {
            ItemStack stack = new ItemStack((ItemLike)ingredientItem, amount);
            if (nbt != null) {
                stack.m_41751_(nbt);
            }
            combinedIngredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
        }
        return Ingredient.merge(combinedIngredients);
    }

    public static void addIngredients(JsonObject mobData, List<Ingredient> ingredientList, String memberName) {
        if (mobData.has(memberName)) {
            for (JsonElement input : mobData.getAsJsonArray(memberName)) {
                CompoundTag nbt = null;
                if (input.getAsJsonObject().has("nbt")) {
                    try {
                        nbt = TagParser.m_129359_((String)input.getAsJsonObject().get("nbt").getAsString());
                    }
                    catch (CommandSyntaxException e) {
                        System.err.println("Invalid NBT data: {}" + input.getAsJsonObject().get("nbt").getAsString());
                    }
                }
                if (input.getAsJsonObject().has("item")) {
                    String ingredient = input.getAsJsonObject().get("item").getAsString();
                    JsonElement amountElement = input.getAsJsonObject().get("amount");
                    if (amountElement != null && amountElement.isJsonObject()) {
                        JsonObject amountObj = amountElement.getAsJsonObject();
                        int min = amountObj.has("min") ? amountObj.get("min").getAsInt() : 1;
                        int max = amountObj.has("max") ? amountObj.get("max").getAsInt() : min;
                        for (int i = min; i <= max; ++i) {
                            ingredientList.add(Utils.createCombinedIngredient(ingredient, i, nbt));
                        }
                        continue;
                    }
                    int amount = input.getAsJsonObject().has("amount") ? input.getAsJsonObject().get("amount").getAsInt() : 1;
                    ingredientList.add(Utils.createCombinedIngredient(ingredient, amount, nbt));
                    continue;
                }
                if (input.getAsJsonObject().has("tag")) {
                    String ingredient = input.getAsJsonObject().get("tag").getAsString();
                    ingredientList.add(Utils.createCombinedIngredientFromTag(ingredient));
                    continue;
                }
                if (!input.getAsJsonObject().has("meat")) continue;
                boolean meat = input.getAsJsonObject().get("meat").getAsBoolean();
                ingredientList.add(Utils.createCombinedIngredient(CommonUtils.getEdibleMeatItemNames(meat)));
            }
        }
    }

    public static BaseRecipe readJsonContents(@NotNull ResourceLocation jsonPath, @NotNull JsonObject json, String recipeType) {
        EntityType<?> entityType;
        JsonArray mobs = json.getAsJsonArray("mobs");
        JsonObject mobObject = mobs.get(0).getAsJsonObject();
        Map.Entry mobEntry = (Map.Entry)mobObject.entrySet().iterator().next();
        String jsonModID = json.get("mod").getAsString();
        String jsonAnimalID = (String)mobEntry.getKey();
        String modFolder = jsonPath.m_135827_();
        String fileName = jsonPath.m_135815_().substring(jsonPath.m_135815_().lastIndexOf(47) + 1);
        if (jsonPath.m_135827_().equals("justenoughbreeding")) {
            modFolder = jsonPath.m_135815_().split("/")[1];
        }
        if (!JustEnoughBreeding.isModLoaded(modFolder).booleanValue() || !JustEnoughBreeding.isModLoaded(jsonModID).booleanValue()) {
            switch (recipeType) {
                case "allay_duplication": {
                    return new AllayDuplicationRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
                case "breeding": {
                    return new BreedingRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
                case "taming": {
                    return new TamingRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
                case "temper": {
                    return new TemperRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
                case "transformation": {
                    return new TransformationRecipe.DummyRecipe(jsonModID, modFolder, fileName);
                }
                case "trusting": {
                    return new TrustingRecipe.DummyRecipe(jsonModID, jsonAnimalID, modFolder, fileName);
                }
            }
        }
        if ((entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(new ResourceLocation(jsonModID, jsonAnimalID))) == null) {
            throw new JsonParseException("Unknown entity: " + jsonModID + ":" + jsonAnimalID + " in " + jsonPath);
        }
        if (!jsonAnimalID.equals(entityType.m_147048_())) {
            throw new JsonParseException("Entity id mismatch. jsonAnimalID=" + jsonAnimalID + " != " + entityType.m_147048_() + " in " + jsonPath);
        }
        ArrayList<Ingredient> inputIngredients = new ArrayList<Ingredient>();
        ArrayList<Ingredient> extraInputIngredients = new ArrayList<Ingredient>();
        ArrayList<Ingredient> outputIngredients = new ArrayList<Ingredient>();
        ArrayList<Ingredient> spawnEggs = new ArrayList<Ingredient>();
        JsonObject mobData = ((JsonElement)mobEntry.getValue()).getAsJsonObject();
        Utils.addIngredients(mobData, inputIngredients, "inputs");
        Utils.addIngredients(mobData, extraInputIngredients, "extra_inputs");
        Utils.addIngredients(mobData, outputIngredients, "outputs");
        if (mobData.has("spawn_eggs")) {
            Utils.addIngredients(mobData, spawnEggs, "spawn_eggs");
        } else {
            ItemStack spawnEgg = Optional.ofNullable(ForgeSpawnEggItem.fromEntityType(entityType)).map(Item::m_7968_).orElse(ItemStack.f_41583_);
            spawnEggs = new ArrayList<Ingredient>(List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{spawnEgg})));
        }
        switch (recipeType) {
            case "trusting": {
                for (TrustingRecipe existingRecipe : JustEnoughBreeding.trustingRecipes) {
                    if (!existingRecipe.jsonModID.equals(jsonModID) || !existingRecipe.jsonAnimalID.equals(jsonAnimalID)) continue;
                    inputIngredients.add(existingRecipe.inputStack);
                    spawnEggs.add(existingRecipe.spawnEgg);
                    extraInputIngredients.add(existingRecipe.extraInputStack);
                    existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
                    existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
                    existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
                    return existingRecipe;
                }
                TrustingRecipe trustingRecipe = new TrustingRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), Utils.deduplicateIngredients(extraInputIngredients), jsonModID, jsonAnimalID, modFolder, fileName);
                JustEnoughBreeding.trustingRecipes.add(trustingRecipe);
                return trustingRecipe;
            }
            case "taming": {
                for (TamingRecipe existingRecipe : JustEnoughBreeding.tamingRecipes) {
                    if (!existingRecipe.jsonModID.equals(jsonModID) || !existingRecipe.jsonAnimalID.equals(jsonAnimalID)) continue;
                    inputIngredients.add(existingRecipe.inputStack);
                    spawnEggs.add(existingRecipe.spawnEgg);
                    extraInputIngredients.add(existingRecipe.extraInputStack);
                    existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
                    existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
                    existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
                    return existingRecipe;
                }
                TamingRecipe tamingRecipe = new TamingRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), Utils.deduplicateIngredients(extraInputIngredients), jsonModID, jsonAnimalID, modFolder, fileName);
                JustEnoughBreeding.tamingRecipes.add(tamingRecipe);
                return tamingRecipe;
            }
            case "allay_duplication": {
                for (AllayDuplicationRecipe existingRecipe : JustEnoughBreeding.allayDuplicationRecipes) {
                    if (!existingRecipe.jsonModID.equals(jsonModID) || !existingRecipe.jsonAnimalID.equals(jsonAnimalID)) continue;
                    inputIngredients.add(existingRecipe.inputStack);
                    spawnEggs.add(existingRecipe.spawnEgg);
                    existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
                    existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
                    return existingRecipe;
                }
                AllayDuplicationRecipe allayDuplicationRecipe = new AllayDuplicationRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), jsonModID, jsonAnimalID, modFolder, fileName);
                JustEnoughBreeding.allayDuplicationRecipes.add(allayDuplicationRecipe);
                return allayDuplicationRecipe;
            }
        }
        for (BreedingRecipe existingRecipe : JustEnoughBreeding.breedingRecipes) {
            if (!existingRecipe.jsonModID.equals(jsonModID) || !existingRecipe.jsonAnimalID.equals(jsonAnimalID)) continue;
            inputIngredients.add(existingRecipe.inputStack);
            extraInputIngredients.add(existingRecipe.extraInputStack);
            outputIngredients.add(existingRecipe.resultItemStack);
            spawnEggs.add(existingRecipe.spawnEgg);
            existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
            existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
            existingRecipe.setOutputIngredient(Utils.deduplicateIngredients(outputIngredients));
            existingRecipe.setSpawnEggs(Utils.deduplicateIngredients(spawnEggs));
            return existingRecipe;
        }
        boolean isTamed = mobData.has("tamed") && mobData.get("tamed").getAsBoolean();
        boolean isTrusting = mobData.has("trusting") && mobData.get("trusting").getAsBoolean();
        BreedingRecipe breedingRecipe = new BreedingRecipe(entityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(spawnEggs), isTamed, Utils.deduplicateIngredients(outputIngredients), Utils.deduplicateIngredients(extraInputIngredients), isTrusting, jsonModID, jsonAnimalID, modFolder, fileName);
        JustEnoughBreeding.breedingRecipes.add(breedingRecipe);
        return breedingRecipe;
    }

    public static Ingredient deduplicateIngredients(List<Ingredient> ingredientList) {
        Ingredient ingredient = Ingredient.merge(ingredientList);
        HashSet<JsonElement> seen = new HashSet<JsonElement>();
        ArrayList<JsonElement> uniqueJson = new ArrayList<JsonElement>();
        JsonElement json = ingredient.m_43942_();
        if (json.isJsonArray()) {
            for (JsonElement el : json.getAsJsonArray()) {
                if (!seen.add(el)) continue;
                uniqueJson.add(el);
            }
        } else {
            seen.add(json);
            uniqueJson.add(json);
        }
        JsonArray result = new JsonArray();
        uniqueJson.forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        return Ingredient.m_43917_((JsonElement)result);
    }
}

