/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.emi;

import com.christofmeg.justenoughbreeding.emi.AbstractRecipeCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.EMIPlugin;
import com.christofmeg.justenoughbreeding.emi.EMIUtils;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BreedingCategoryEMI
extends AbstractRecipeCategoryEMI {
    private final BreedingRecipe recipe;
    public static final EmiRecipeCategory TYPE = new EmiRecipeCategory(new ResourceLocation("justenoughbreeding:breeding"), (EmiRenderable)EmiStack.of((ItemLike)Items.f_42405_), EMIPlugin.simplifiedRenderer(), EmiRecipeSorting.none());

    protected BreedingCategoryEMI(Builder builder, BreedingRecipe breedingRecipe) {
        super(TYPE, 168, 93, builder.id);
        this.recipe = breedingRecipe;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of((Ingredient)this.recipe.inputStack));
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(EmiIngredient.of((Ingredient)this.recipe.inputStack), EmiIngredient.of((Ingredient)this.recipe.extraInputStack), EmiIngredient.of((Ingredient)this.recipe.spawnEgg));
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> list = new ArrayList<EmiStack>();
        if (this.recipe.resultItemStack != null) {
            for (ItemStack item : this.recipe.resultItemStack.m_43908_()) {
                list.add(EmiStack.of((ItemStack)item));
            }
            for (ItemStack item : this.recipe.spawnEgg.m_43908_()) {
                list.add(EmiStack.of((ItemStack)item));
            }
        }
        return list;
    }

    public void addWidgets(WidgetHolder widgets) {
        boolean hasOutput;
        widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.spawnEgg), 149, 1);
        int inputX = 74;
        int inputY = 48;
        boolean hasExtraInput = this.recipe.extraInputStack != null && !this.recipe.extraInputStack.m_43947_();
        boolean bl = hasOutput = this.recipe.resultItemStack != null && !this.recipe.resultItemStack.m_43947_();
        if (hasExtraInput && hasOutput) {
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.inputStack), inputX, 38);
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.extraInputStack), inputX, 57);
        } else if (hasExtraInput) {
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.inputStack), inputX + 33, 38);
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.extraInputStack), inputX + 33, 57);
        } else if (!hasOutput) {
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.inputStack), inputX + 33, inputY);
        } else {
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.inputStack), inputX, inputY);
        }
        if (hasOutput) {
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 98, 48);
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.resultItemStack), 130, 44).large(true).recipeContext((EmiRecipe)this);
        }
        EMIUtils.drawMobSlot(0, 10, widgets);
        EMIUtils.drawMobNameAndEntity(this.recipe.entityType, widgets, this.recipe);
    }

    public static class Builder {
        private ResourceLocation id;
        private BreedingRecipe recipe;

        private Builder() {
        }

        public EmiRecipe build() {
            return new BreedingCategoryEMI(this, this.recipe);
        }

        public Builder id(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder recipe(BreedingRecipe recipe) {
            this.recipe = recipe;
            return this;
        }
    }
}

