/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.OfflineAccount;
import ru.vidtu.ias.auth.microsoft.MSAuth;
import ru.vidtu.ias.config.IASConfig;
import ru.vidtu.ias.screen.PopupBox;
import ru.vidtu.ias.screen.PopupButton;

public final class OfflinePopupScreen
extends Screen {
    private final Screen parent;
    private final Consumer<Account> handler;
    private PopupBox name;
    private PopupButton done;
    private boolean locked = false;

    OfflinePopupScreen(Screen parent, Consumer<Account> handler) {
        super((Component)Component.m_237115_((String)"ias.offline"));
        this.parent = parent;
        this.handler = handler;
    }

    protected void m_7856_() {
        assert (this.f_96541_ != null);
        if (this.parent != null) {
            this.parent.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
        this.name = new PopupBox(this.f_96547_, this.f_96543_ / 2 - 75, this.f_96544_ / 2 - 10 + 5, 148, 20, this.name, (Component)Component.m_237115_((String)"ias.offline.nick"), this::done, false);
        this.name.m_94199_(16);
        if (IASConfig.unexpectedPigs) {
            this.name.m_257771_((Component)Component.m_237113_((String)("Boar" + ((Object)((Object)this)).hashCode())).m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            this.name.m_257771_((Component)Component.m_237113_((String)"Steve").m_130940_(ChatFormatting.DARK_GRAY));
        }
        this.m_142416_((GuiEventListener)this.name);
        this.done = new PopupButton(this.f_96543_ / 2 - 75, this.f_96544_ / 2 + 49 - 22, 74, 20, CommonComponents.f_130655_, btn -> this.done(), Supplier::get);
        this.done.color(1.0f, 0.5f, 0.5f, true);
        this.m_142416_((GuiEventListener)this.done);
        PopupButton button = new PopupButton(this.f_96543_ / 2 + 1, this.f_96544_ / 2 + 49 - 22, 74, 20, CommonComponents.f_130656_, btn -> this.m_7379_(), Supplier::get);
        button.color(1.0f, 1.0f, 1.0f, true);
        this.m_142416_((GuiEventListener)button);
        this.name.m_94151_(value -> this.type(false));
        this.type(true);
    }

    private void done() {
        assert (this.f_96541_ != null);
        if (this.name == null) {
            return;
        }
        String value = this.name.m_94155_();
        if (value.isBlank()) {
            return;
        }
        int length = value.length();
        if (length < 3 || length > 16) {
            this.handler.accept(new OfflineAccount(value, null));
            return;
        }
        for (int i = 0; i < length; ++i) {
            int c = value.codePointAt(i);
            if (c == 95 || c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90) continue;
            this.handler.accept(new OfflineAccount(value, null));
            return;
        }
        this.locked = true;
        this.type(false);
        MSAuth.nameToMcp(value).whenCompleteAsync((profile, throwable) -> {
            UUID skin = profile != null ? profile.uuid() : null;
            this.handler.accept(new OfflineAccount(value, skin));
        }, (Executor)this.f_96541_);
    }

    private void type(boolean instant) {
        if (this.done == null || this.name == null) {
            return;
        }
        if (this.locked) {
            this.done.f_93623_ = false;
            this.name.f_93623_ = false;
            this.done.m_257544_(null);
            this.done.color(0.5f, 0.5f, 0.5f, instant);
            return;
        }
        String value = this.name.m_94155_();
        this.name.f_93623_ = true;
        if (value.isBlank()) {
            this.done.f_93623_ = false;
            this.done.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ias.offline.nick.blank")));
            this.done.m_257427_(-1);
            this.done.color(1.0f, 0.5f, 0.5f, instant);
            return;
        }
        this.done.f_93623_ = true;
        int length = value.length();
        if (length < 3) {
            if (Screen.m_96639_()) {
                this.done.f_93623_ = true;
                this.done.color(0.75f, 0.75f, 0.25f, instant);
            } else {
                this.done.f_93623_ = false;
                this.done.color(1.0f, 1.0f, 0.5f, instant);
            }
            this.done.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"ias.offline.nick.short", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.alt")})));
            this.done.m_257427_(-1);
            return;
        }
        if (length > 16) {
            if (Screen.m_96639_()) {
                this.done.f_93623_ = true;
                this.done.color(0.75f, 0.75f, 0.25f, instant);
            } else {
                this.done.f_93623_ = false;
                this.done.color(1.0f, 1.0f, 0.5f, instant);
            }
            this.done.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"ias.offline.nick.long", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.alt")})));
            this.done.m_257427_(-1);
            return;
        }
        for (int i = 0; i < length; ++i) {
            int c = value.codePointAt(i);
            if (c == 95 || c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90) continue;
            this.done.f_93623_ = Screen.m_96639_();
            if (Screen.m_96639_()) {
                this.done.f_93623_ = true;
                this.done.color(0.75f, 0.75f, 0.25f, instant);
            } else {
                this.done.f_93623_ = false;
                this.done.color(1.0f, 1.0f, 0.5f, instant);
            }
            this.done.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"ias.offline.nick.chars", (Object[])new Object[]{Character.toString(c), Component.m_237115_((String)"key.keyboard.left.alt")})));
            this.done.m_257427_(-1);
            return;
        }
        this.done.color(0.5f, 1.0f, 0.5f, instant);
        this.done.m_257544_(null);
    }

    public void m_86600_() {
        super.m_86600_();
        this.name.m_94120_();
    }

    public boolean m_7933_(int key, int scan, int mods) {
        boolean res = super.m_7933_(key, scan, mods);
        if (key == 342 || key == 346) {
            this.type(false);
        }
        return res;
    }

    public boolean m_7920_(int key, int scan, int mods) {
        boolean res = super.m_7920_(key, scan, mods);
        if (key == 342 || key == 346) {
            this.type(false);
        }
        return res;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.f_96541_ != null);
        PoseStack pose = graphics.m_280168_();
        if (this.parent != null) {
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, -1000.0f);
            this.parent.m_88315_(graphics, 0, 0, delta);
            pose.m_85849_();
        }
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        pose.m_85836_();
        pose.m_85841_(2.0f, 2.0f, 2.0f);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 4, this.f_96544_ / 4 - 24, -1);
        pose.m_85849_();
        if (this.name != null) {
            graphics.m_280653_(this.f_96547_, this.name.m_6035_(), this.f_96543_ / 2, this.f_96544_ / 2 - 10 - 5, -1);
        }
    }

    public void m_280273_(GuiGraphics graphics) {
        assert (this.f_96541_ != null);
        if (this.parent != null) {
            graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE);
        } else {
            super.m_280273_(graphics);
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        graphics.m_280509_(centerX - 80, centerY - 50, centerX + 80, centerY + 50, -132112336);
        graphics.m_280509_(centerX - 79, centerY - 51, centerX + 79, centerY - 50, -132112336);
        graphics.m_280509_(centerX - 79, centerY + 50, centerX + 79, centerY + 51, -132112336);
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    public String toString() {
        return "OfflinePopupScreen{}";
    }
}

