/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.IASMinecraft;
import ru.vidtu.ias.auth.LoginData;
import ru.vidtu.ias.auth.handlers.LoginHandler;
import ru.vidtu.ias.config.IASConfig;
import ru.vidtu.ias.screen.PopupBox;
import ru.vidtu.ias.screen.PopupButton;
import ru.vidtu.ias.utils.exceptions.FriendlyException;

final class LoginPopupScreen
extends Screen
implements LoginHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/LoginPopupScreen");
    private final Screen parent;
    private final Object lock = new Object();
    private Component stage = Component.m_237115_((String)"ias.login.initializing").m_130940_(ChatFormatting.YELLOW);
    private MultiLineLabel label;
    private PopupBox password;
    private CompletableFuture<String> passFuture;
    private MultiLineLabel cryptPasswordTip;
    private float error = Float.NaN;
    private MultiLineLabel errorNote;

    LoginPopupScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"ias.login"));
        this.parent = parent;
    }

    @Override
    public boolean cancelled() {
        assert (this.f_96541_ != null);
        return this != this.f_96541_.f_91080_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void m_7856_() {
        assert (this.f_96541_ != null);
        Object object = this.lock;
        synchronized (object) {
            this.label = null;
        }
        if (this.parent != null) {
            this.parent.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
        this.m_142416_((GuiEventListener)new PopupButton(this.f_96543_ / 2 - 75, this.f_96544_ / 2 + 74 - 22, 150, 20, CommonComponents.f_130656_, btn -> this.m_7379_(), Supplier::get));
        if (this.passFuture != null) {
            this.password = new PopupBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 10 + 5, 178, 20, this.password, (Component)Component.m_237115_((String)"ias.password"), () -> {
                if (this.passFuture == null || this.password == null) {
                    return;
                }
                String value = this.password.m_94155_();
                if (value.isBlank()) {
                    return;
                }
                this.passFuture.complete(value);
            }, true);
            this.password.m_257771_((Component)Component.m_237115_((String)"ias.password.hint").m_130940_(ChatFormatting.DARK_GRAY));
            this.password.m_94149_((s, i) -> IASConfig.passwordEchoing ? FormattedCharSequence.m_13714_((String)"*".repeat(s.length()), (Style)Style.f_131099_) : FormattedCharSequence.f_13691_);
            this.password.m_94199_(32);
            this.m_142416_((GuiEventListener)this.password);
            PopupButton button = new PopupButton(this.f_96543_ / 2 - 100 + 180, this.f_96544_ / 2 - 10 + 5, 20, 20, (Component)Component.m_237113_((String)">>"), btn -> {
                if (this.passFuture == null || this.password == null) {
                    return;
                }
                String value = this.password.m_94155_();
                if (value.isBlank()) {
                    return;
                }
                this.passFuture.complete(value);
            }, Supplier::get);
            button.f_93623_ = !this.password.m_94155_().isBlank();
            this.m_142416_((GuiEventListener)button);
            this.password.m_94151_(value -> {
                button.f_93623_ = !value.isBlank();
            });
            this.cryptPasswordTip = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)Component.m_237115_((String)"ias.password.tip"), (int)320);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.password == null) {
            return;
        }
        this.password.m_94120_();
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        if (this.passFuture != null) {
            this.passFuture.complete(null);
        }
        this.f_96541_.m_91152_(this.parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        assert (this.f_96541_ != null);
        PoseStack pose = graphics.m_280168_();
        if (this.parent != null) {
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, -1000.0f);
            this.parent.m_88315_(graphics, 0, 0, delta);
            pose.m_85849_();
        }
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        pose.m_85836_();
        pose.m_85841_(2.0f, 2.0f, 2.0f);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 4, this.f_96544_ / 4 - 37, -1);
        pose.m_85849_();
        if (this.passFuture != null && this.password != null && this.cryptPasswordTip != null) {
            graphics.m_280653_(this.f_96547_, this.password.m_6035_(), this.f_96543_ / 2, this.f_96544_ / 2 - 10 - 5, -1);
            pose.m_85836_();
            pose.m_85841_(0.5f, 0.5f, 0.5f);
            this.cryptPasswordTip.m_6514_(graphics, this.f_96543_, this.f_96544_ + 40, 10, -256);
            pose.m_85849_();
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.label == null) {
                    Component component = (Component)Objects.requireNonNullElse(this.stage, Component.m_237119_());
                    this.label = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)component, (int)240);
                    this.f_96541_.m_240477_().m_263195_(component);
                }
                this.label.m_6514_(graphics, this.f_96543_ / 2, (this.f_96544_ - this.label.m_5770_() * 9) / 2 - 4, 9, -1);
            }
            if (Float.isFinite(this.error)) {
                int opacityMask;
                if (this.errorNote == null) {
                    this.errorNote = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)Component.m_237115_((String)"ias.error.note").m_130940_(ChatFormatting.AQUA), (int)245);
                }
                if (this.error < 1.0f) {
                    this.error = Math.min(this.error + delta * 0.1f, 1.0f);
                    int opacity = Math.max(9, (int)(this.error * this.error * this.error * this.error * 255.0f));
                    opacityMask = opacity << 24;
                } else {
                    opacityMask = -16777216;
                }
                int w = this.errorNote.m_214161_() / 4 + 2;
                int h = this.errorNote.m_5770_() * 9 / 2 + 1;
                int cx = this.f_96543_ / 2;
                int sy = this.f_96544_ / 2 + 87;
                graphics.m_280509_(cx - w, sy, cx + w, sy + h, 0x101010 | opacityMask);
                graphics.m_280509_(cx - w + 1, sy - 1, cx + w - 1, sy, 0x101010 | opacityMask);
                graphics.m_280509_(cx - w + 1, sy + h, cx + w - 1, sy + h + 1, 0x101010 | opacityMask);
                pose.m_85836_();
                pose.m_85841_(0.5f, 0.5f, 0.5f);
                this.errorNote.m_6514_(graphics, this.f_96543_, this.f_96544_ + 174, 9, 0xFFFFFF | opacityMask);
                pose.m_85849_();
            }
        }
    }

    public void m_280273_(GuiGraphics graphics) {
        assert (this.f_96541_ != null);
        if (this.parent != null) {
            graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE);
        } else {
            super.m_280273_(graphics);
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        graphics.m_280509_(centerX - 125, centerY - 75, centerX + 125, centerY + 75, -132112336);
        graphics.m_280509_(centerX - 124, centerY - 76, centerX + 124, centerY - 75, -132112336);
        graphics.m_280509_(centerX - 124, centerY + 75, centerX + 124, centerY + 76, -132112336);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stage(String stage, Object ... args) {
        assert (this.f_96541_ != null);
        if (this != this.f_96541_.f_91080_) {
            return;
        }
        MutableComponent component = Component.m_237110_((String)stage, (Object[])args).m_130940_(ChatFormatting.YELLOW);
        Object object = this.lock;
        synchronized (object) {
            this.stage = component;
            this.label = null;
        }
    }

    @Override
    public CompletableFuture<String> password() {
        assert (this.f_96541_ != null);
        if (this.passFuture != null) {
            return this.passFuture;
        }
        this.passFuture = new CompletableFuture();
        this.passFuture.thenAcceptAsync(password -> {
            this.passFuture = null;
            this.password = null;
            this.cryptPasswordTip = null;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }, (Executor)this.f_96541_);
        this.f_96541_.execute(() -> this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_));
        return this.passFuture;
    }

    @Override
    public void success(LoginData data, boolean changed) {
        assert (this.f_96541_ != null);
        if (this != this.f_96541_.f_91080_) {
            return;
        }
        if (data == null) {
            this.f_96541_.execute(() -> {
                if (this != this.f_96541_.f_91080_) {
                    return;
                }
                this.f_96541_.m_91152_(this.parent);
            });
            return;
        }
        this.stage("ias.login.services", new Object[0]);
        if (changed) {
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
        }
        ((CompletableFuture)IASMinecraft.account(this.f_96541_, data).thenRunAsync(() -> {
            if (this != this.f_96541_.f_91080_) {
                return;
            }
            this.f_96541_.m_91152_(this.parent);
        }, (Executor)this.f_96541_)).exceptionally(ex -> {
            this.error(new RuntimeException("Unable to change account.", (Throwable)ex));
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(Throwable error) {
        assert (this.f_96541_ != null);
        LOGGER.error("IAS: Login error.", error);
        if (this != this.f_96541_.f_91080_) {
            return;
        }
        FriendlyException probable = FriendlyException.friendlyInChain(error);
        String key = probable != null ? probable.key() : "ias.error";
        MutableComponent component = Component.m_237115_((String)key).m_130940_(ChatFormatting.RED);
        Object object = this.lock;
        synchronized (object) {
            this.stage = component;
            this.label = null;
            this.error = 0.0f;
        }
    }

    public String toString() {
        return "LoginPopupScreen{stage=" + this.stage + ", label=" + this.label + "}";
    }
}

