/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.config.IASStorage;
import ru.vidtu.ias.legacy.Skin;
import ru.vidtu.ias.legacy.SkinWidget;
import ru.vidtu.ias.screen.AccountEntry;
import ru.vidtu.ias.screen.AccountList;

public final class AccountScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/AccountScreen");
    private final Screen parent;
    private EditBox search;
    private AccountList list;
    private SkinWidget skin;
    private Button login;
    private Button offlineLogin;
    private Button edit;
    private Button delete;

    public AccountScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"ias.accounts"));
        this.parent = parent;
    }

    protected void m_7856_() {
        assert (this.f_96541_ != null);
        if (IAS.disabled()) {
            this.f_96541_.m_91152_((Screen)new AlertScreen(this::m_7379_, (Component)Component.m_237115_((String)"ias.disabled.title").m_130940_(ChatFormatting.RED), (Component)Component.m_237115_((String)"ias.disabled.text"), CommonComponents.f_130660_, true));
            return;
        }
        if (!IASStorage.gameDisclaimerShown) {
            this.f_96541_.m_91152_((Screen)new AlertScreen(() -> {
                try {
                    IAS.gameDisclaimerShownStorage();
                }
                catch (Throwable t) {
                    LOGGER.error("Unable to set or write game disclaimer state.", t);
                }
                this.f_96541_.m_91152_((Screen)this);
            }, (Component)Component.m_237115_((String)"ias.disclaimer.title").m_130940_(ChatFormatting.YELLOW), (Component)Component.m_237115_((String)"ias.disclaimer.text"), CommonComponents.f_263736_, false));
            return;
        }
        this.search = new EditBox(this.f_96547_, this.f_96543_ / 2 - 75, 11, 150, 20, this.search, (Component)Component.m_237115_((String)"ias.accounts.search"));
        this.search.m_257771_((Component)this.search.m_6035_().m_6881_().m_130940_(ChatFormatting.DARK_GRAY));
        this.m_142416_((GuiEventListener)this.search);
        if (this.skin == null) {
            this.skin = new SkinWidget(5, this.f_96544_ / 2 - 60, 85, 120, this.f_96541_.m_167973_(), () -> {
                if (this.list == null) {
                    return Skin.getDefault(Util.f_137441_);
                }
                AccountEntry selected = (AccountEntry)this.list.m_93511_();
                if (selected == null) {
                    return Skin.getDefault(Util.f_137441_);
                }
                return this.list.skin(selected);
            });
        }
        this.m_142416_((GuiEventListener)this.skin);
        this.login = Button.m_253074_((Component)Component.m_237115_((String)"ias.accounts.login"), btn -> this.list.login(true)).m_252987_(this.f_96543_ / 2 - 50 - 100 - 4, this.f_96544_ - 24 - 24, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.login);
        this.offlineLogin = Button.m_253074_((Component)Component.m_237115_((String)"ias.accounts.offlineLogin"), btn -> this.list.login(false)).m_252987_(this.f_96543_ / 2 - 50 - 100 - 4, this.f_96544_ - 24, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.offlineLogin);
        this.edit = Button.m_253074_((Component)Component.m_237115_((String)"ias.accounts.edit"), btn -> this.list.edit()).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ - 24 - 24, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.edit);
        this.delete = Button.m_253074_((Component)Component.m_237115_((String)"ias.accounts.delete"), btn -> this.list.delete(!Screen.m_96638_())).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ - 24, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.delete);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"ias.accounts.add"), btn -> this.list.add()).m_252987_(this.f_96543_ / 2 + 50 + 4, this.f_96544_ - 24 - 24, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, btn -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 50 + 4, this.f_96544_ - 24, 100, 20).m_253136_());
        if (this.list != null) {
            this.list.m_93437_(this.f_96543_, this.f_96544_ - 24 - 24 - 4 - 34, 34, this.f_96544_ - 24 - 24 - 4);
        } else {
            this.list = new AccountList(this, this.f_96541_, this.f_96543_, this.f_96544_ - 24 - 24 - 4 - 34, 34, this.f_96544_ - 24 - 24 - 4, 12);
        }
        this.m_142416_((GuiEventListener)this.list);
        this.search.m_94151_(this.list::update);
        this.list.update(this.search.m_94155_());
        this.updateSelected();
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 1, -1);
    }

    public void m_86600_() {
        super.m_86600_();
        this.search.m_94120_();
    }

    EditBox search() {
        return this.search;
    }

    void updateSelected() {
        AccountEntry selected;
        AccountEntry accountEntry = selected = this.list != null ? (AccountEntry)this.list.m_93511_() : null;
        if (selected == null) {
            this.delete.f_93623_ = false;
            this.edit.f_93623_ = false;
            this.offlineLogin.f_93623_ = false;
            this.login.f_93623_ = false;
            this.login.m_257544_(null);
            this.skin.f_93624_ = false;
            return;
        }
        this.delete.f_93623_ = true;
        this.edit.f_93623_ = true;
        this.offlineLogin.f_93623_ = true;
        if (selected.account().canLogin()) {
            this.login.f_93623_ = true;
            this.login.m_257544_(null);
        } else {
            this.login.f_93623_ = false;
            this.login.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ias.accounts.login.offline")));
            this.login.m_257427_(-1);
        }
        this.skin.f_93624_ = true;
    }

    public boolean m_7933_(int key, int scan, int mods) {
        AccountEntry selected;
        assert (this.f_96541_ != null);
        if (key == 264 && Screen.m_96638_() || key == 267) {
            this.list.swapDown((AccountEntry)this.list.m_93511_());
            return true;
        }
        if (key == 265 && Screen.m_96638_() || key == 266) {
            this.list.swapUp((AccountEntry)this.list.m_93511_());
            return true;
        }
        if (key == 67 && Screen.m_96637_() && (selected = (AccountEntry)this.list.m_93511_()) != null) {
            Account account = selected.account();
            this.f_96541_.f_91068_.m_90911_(Screen.m_96638_() ? account.uuid().toString() : account.name());
            return true;
        }
        if (super.m_7933_(key, scan, mods)) {
            return true;
        }
        if (CommonInputs.m_278691_((int)key)) {
            this.list.login(!Screen.m_96638_());
            return true;
        }
        if (key == 261 || key == 333) {
            this.list.delete(!Screen.m_96638_());
            return true;
        }
        if (key == 78 && Screen.m_96637_() || key == 334) {
            this.list.add();
            return true;
        }
        if (key == 82 && Screen.m_96637_() || key == 332) {
            this.list.edit();
            return true;
        }
        return false;
    }

    public String toString() {
        return "AccountScreen{list=" + this.list + "}";
    }
}

