/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vidtu.ias.IAS;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.OfflineAccount;
import ru.vidtu.ias.auth.LoginData;
import ru.vidtu.ias.config.IASStorage;
import ru.vidtu.ias.legacy.Skin;
import ru.vidtu.ias.screen.AccountEntry;
import ru.vidtu.ias.screen.AccountScreen;
import ru.vidtu.ias.screen.AddPopupScreen;
import ru.vidtu.ias.screen.DeletePopupScreen;
import ru.vidtu.ias.screen.LoginPopupScreen;

final class AccountList
extends ObjectSelectionList<AccountEntry> {
    private static final Map<UUID, Skin> SKINS = new WeakHashMap<UUID, Skin>(4);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IAS/AccountList");
    private final AccountScreen screen;

    AccountList(AccountScreen screen, Minecraft minecraft, int width, int height, int top, int bottom, int item) {
        super(minecraft, width, height, top, bottom, item);
        this.screen = screen;
        this.update(this.screen.search().m_94155_());
        this.m_93496_(false);
    }

    public int m_5759_() {
        return Math.min(super.m_5759_(), this.screen.f_96543_ - 190);
    }

    public void setSelected(@Nullable AccountEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        this.screen.updateSelected();
    }

    void update(String query) {
        if (query == null || query.isBlank()) {
            AccountEntry selected = (AccountEntry)this.m_93511_();
            this.m_5988_(IASStorage.ACCOUNTS.stream().map(account -> new AccountEntry(this.f_93386_, this, (Account)account)).toList());
            this.setSelected(this.m_6702_().contains((Object)selected) ? selected : null);
            this.screen.updateSelected();
            return;
        }
        String lowerQuery = query.toLowerCase(Locale.ROOT);
        AccountEntry selected = (AccountEntry)this.m_93511_();
        this.m_5988_(IASStorage.ACCOUNTS.stream().filter(account -> account.name().toLowerCase(Locale.ROOT).contains(lowerQuery)).sorted((f, s) -> Boolean.compare(s.name().toLowerCase(Locale.ROOT).startsWith(lowerQuery), f.name().toLowerCase(Locale.ROOT).startsWith(lowerQuery))).map(account -> new AccountEntry(this.f_93386_, this, (Account)account)).toList());
        this.setSelected(this.m_6702_().contains((Object)selected) ? selected : null);
        this.screen.updateSelected();
    }

    void login(boolean online) {
        AccountEntry selected = (AccountEntry)this.m_93511_();
        if (selected == null) {
            return;
        }
        Account account = selected.account();
        if (online && account.canLogin()) {
            LoginPopupScreen login = new LoginPopupScreen(this.screen);
            this.f_93386_.m_91152_((Screen)login);
            IAS.executor().execute(() -> account.login(login));
            return;
        }
        LoginPopupScreen login = new LoginPopupScreen(this.screen);
        this.f_93386_.m_91152_((Screen)login);
        String name = account.name();
        LoginData data = new LoginData(name, OfflineAccount.uuid(name), "ias:offline", false);
        login.success(data, false);
    }

    void edit() {
        AccountEntry selected = (AccountEntry)this.m_93511_();
        if (selected == null) {
            return;
        }
        int index = this.m_6702_().indexOf((Object)selected);
        if (index < 0 || index >= IASStorage.ACCOUNTS.size()) {
            return;
        }
        this.f_93386_.m_91152_((Screen)new AddPopupScreen(this.screen, true, account -> {
            this.f_93386_.m_91152_((Screen)this.screen);
            IASStorage.ACCOUNTS.removeIf(Predicate.isEqual(account));
            if (index >= IASStorage.ACCOUNTS.size()) {
                IASStorage.ACCOUNTS.add((Account)account);
            } else {
                IASStorage.ACCOUNTS.set(index, (Account)account);
            }
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().m_94155_());
        }));
    }

    void delete(boolean confirm) {
        AccountEntry selected = (AccountEntry)this.m_93511_();
        if (selected == null) {
            return;
        }
        Account account = selected.account();
        if (!confirm) {
            IASStorage.ACCOUNTS.remove(account);
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().m_94155_());
            return;
        }
        this.f_93386_.m_91152_((Screen)new DeletePopupScreen(this.screen, account, () -> {
            IASStorage.ACCOUNTS.removeIf(Predicate.isEqual(account));
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().m_94155_());
        }));
    }

    void add() {
        this.f_93386_.m_91152_((Screen)new AddPopupScreen(this.screen, false, account -> {
            this.f_93386_.m_91152_((Screen)this.screen);
            IASStorage.ACCOUNTS.removeIf(Predicate.isEqual(account));
            IASStorage.ACCOUNTS.add((Account)account);
            try {
                IAS.disclaimersStorage();
                IAS.saveStorage();
            }
            catch (Throwable t) {
                LOGGER.error("IAS: Unable to save storage.", t);
            }
            this.update(this.screen.search().m_94155_());
        }));
    }

    Skin skin(AccountEntry entry) {
        UUID uuid = entry.account().skin();
        Skin skin = SKINS.get(uuid);
        if (skin != null) {
            return skin;
        }
        skin = Skin.getDefault(uuid);
        SKINS.put(uuid, skin);
        if (uuid.version() != 4) {
            return skin;
        }
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            GameProfile profile = new GameProfile(uuid, entry.account().name());
            return this.f_93386_.m_91108_().fillProfileProperties(profile, false);
        }, IAS.executor()).thenApplyAsync(profile -> {
            if (profile == null) {
                return null;
            }
            return this.f_93386_.m_91109_().m_118815_(profile);
        }, (Executor)IAS.executor())).thenAcceptAsync(loaded -> {
            if (loaded == null) {
                return;
            }
            MinecraftProfileTexture skinInfo = (MinecraftProfileTexture)loaded.get(MinecraftProfileTexture.Type.SKIN);
            if (skinInfo == null) {
                return;
            }
            ResourceLocation skinTexture = this.f_93386_.m_91109_().m_118825_(skinInfo, MinecraftProfileTexture.Type.SKIN);
            boolean slim = "slim".equalsIgnoreCase(skinInfo.getMetadata("model"));
            SKINS.put(uuid, new Skin(skinTexture, slim));
        }, (Executor)this.f_93386_)).exceptionally(t -> {
            LOGGER.warn("IAS: Unable to load skin: {}", (Object)entry, t);
            return null;
        });
        return skin;
    }

    void swapUp(AccountEntry entry) {
        int idx = this.m_6702_().indexOf((Object)entry);
        if (idx < 0 || idx >= IASStorage.ACCOUNTS.size()) {
            return;
        }
        int upIdx = idx - 1;
        if (upIdx < 0) {
            return;
        }
        IASStorage.ACCOUNTS.set(idx, IASStorage.ACCOUNTS.get(upIdx));
        IASStorage.ACCOUNTS.set(upIdx, entry.account());
        try {
            IAS.disclaimersStorage();
            IAS.saveStorage();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to save storage.", t);
        }
        this.m_6702_().set(idx, (AccountEntry)((Object)this.m_6702_().get(upIdx)));
        this.m_6702_().set(upIdx, entry);
        this.setSelected(entry);
    }

    void swapDown(AccountEntry entry) {
        int idx = this.m_6702_().indexOf((Object)entry);
        if (idx < 0 || idx >= IASStorage.ACCOUNTS.size()) {
            return;
        }
        int downIdx = idx + 1;
        if (downIdx >= this.m_6702_().size() || downIdx >= IASStorage.ACCOUNTS.size()) {
            return;
        }
        IASStorage.ACCOUNTS.set(idx, IASStorage.ACCOUNTS.get(downIdx));
        IASStorage.ACCOUNTS.set(downIdx, entry.account());
        try {
            IAS.disclaimersStorage();
            IAS.saveStorage();
        }
        catch (Throwable t) {
            LOGGER.error("IAS: Unable to save storage.", t);
        }
        this.m_6702_().set(idx, (AccountEntry)((Object)this.m_6702_().get(downIdx)));
        this.m_6702_().set(downIdx, entry);
        this.setSelected(entry);
    }

    AccountScreen screen() {
        return this.screen;
    }

    public String toString() {
        return "AccountList{children=" + this.m_6702_() + "}";
    }
}

