/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.screen;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import ru.vidtu.ias.IASMinecraft;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.legacy.Skin;
import ru.vidtu.ias.screen.AccountList;

final class AccountEntry
extends ObjectSelectionList.Entry<AccountEntry> {
    private final Minecraft minecraft;
    private final AccountList list;
    private final Account account;
    private final List<FormattedCharSequence> tooltip;
    private long clicked = Util.m_137550_();
    private long lastFree = System.nanoTime();

    AccountEntry(Minecraft minecraft, AccountList list, Account account) {
        this.minecraft = minecraft;
        this.list = list;
        this.account = account;
        this.tooltip = Stream.of(CommonComponents.m_178393_((Component)Component.m_237115_((String)"ias.accounts.tip.nick"), (Component)Component.m_237113_((String)this.account.name())), CommonComponents.m_178393_((Component)Component.m_237115_((String)"ias.accounts.tip.uuid"), (Component)Component.m_237113_((String)this.account.uuid().toString())), CommonComponents.m_178393_((Component)Component.m_237115_((String)"ias.accounts.tip.type"), (Component)Component.m_237115_((String)this.account.typeTipKey()))).map(Component::m_7532_).toList();
    }

    public void m_6311_(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        if (hovered) {
            if (System.nanoTime() - this.lastFree >= 500000000L) {
                this.list.screen().m_257959_(this.tooltip);
            }
        } else {
            this.lastFree = System.nanoTime();
        }
        Skin skin = this.list.skin(this);
        PlayerFaceRenderer.m_280354_((GuiGraphics)graphics, (ResourceLocation)skin.skin(), (int)x, (int)y, (int)8);
        User user = this.minecraft.m_91094_();
        int color = user == null || !this.account.name().equalsIgnoreCase(user.m_92546_()) ? -1 : (this.account.uuid().equals(user.m_240411_()) ? -16711936 : (this.account.name().equals(user.m_92546_()) ? -256 : Short.MIN_VALUE));
        graphics.m_280488_(this.minecraft.f_91062_, this.account.name(), x + 10, y, color);
        if (this.account.insecure()) {
            boolean warning = System.nanoTime() / 1000000000L % 2L == 0L;
            graphics.m_280218_(IASMinecraft.SPRITE, x - 6, y - 1, 31, warning ? 10 : 0, 2, 10);
            if (mouseX >= x - 10 && mouseX <= x && mouseY >= y && mouseY <= y + height) {
                this.list.screen().m_262791_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ias.accounts.tip.insecure")), DefaultTooltipPositioner.f_262752_, true);
            }
        }
        if (this.equals(this.list.m_7222_()) || this.equals(this.list.m_93511_())) {
            int upX = x + width - 28;
            int upV = this == this.list.m_6702_().get(0) ? 14 : (mouseX >= upX && mouseY >= y && mouseX <= upX + 11 && mouseY <= y + height ? 7 : 0);
            graphics.m_280218_(IASMinecraft.SPRITE, upX, y, 20, upV, 11, 7);
            int downX = x + width - 15;
            int downV = this == this.list.m_6702_().get(this.list.m_6702_().size() - 1) ? 35 : (mouseX >= downX && mouseY >= y && mouseX <= downX + 11 && mouseY <= y + height ? 28 : 21);
            graphics.m_280218_(IASMinecraft.SPRITE, downX, y, 20, downV, 11, 7);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.equals(this.list.m_7222_()) || this.equals(this.list.m_93511_())) {
            int right = this.list.m_93520_();
            int upX = right - 28;
            if (mouseX >= (double)upX && mouseX <= (double)(upX + 11)) {
                this.list.swapUp(this);
                return true;
            }
            int downX = right - 15;
            if (mouseX >= (double)downX && mouseX <= (double)(downX + 11)) {
                this.list.swapDown(this);
                return true;
            }
        }
        if (Util.m_137550_() - this.clicked < 250L) {
            this.list.login(!Screen.m_96638_());
        }
        this.clicked = Util.m_137550_();
        return true;
    }

    @NotNull
    public Component m_142172_() {
        return Component.m_237113_((String)this.account.name());
    }

    Account account() {
        return this.account;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccountEntry)) {
            return false;
        }
        AccountEntry that = (AccountEntry)((Object)obj);
        return Objects.equals(this.account, that.account);
    }

    public int hashCode() {
        return Objects.hashCode(this.account);
    }

    public String toString() {
        return "AccountEntry{account=" + this.account + "}";
    }
}

